/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.grid.timer;

import com.alibaba.dts.client.executor.grid.GridJobManager;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.NamedThreadFactory;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class JobInstanceMapCleaner
implements Runnable {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(JobInstanceMapCleaner.class);
    private ScheduledThreadPoolExecutor threadPoolExecutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("SchedulerX-JobInstanceMapCleaner-Thread#"));
    private ClientContextImpl clientContext;
    private long interval = 900000L;

    public JobInstanceMapCleaner(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void init() {
        this.threadPoolExecutor.scheduleAtFixedRate(this, 0L, 3L, TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        try {
            GridJobManager gridJobManager = this.clientContext.getGridJobManager();
            logger.info("start to clean job instance map, size={}", (Object)gridJobManager.getInterruptedJobInstanceMap().size());
            long now = System.currentTimeMillis();
            for (Map.Entry<Long, Long> jobInstanceIdAndtime : gridJobManager.getInterruptedJobInstanceMap().entrySet()) {
                if (now - jobInstanceIdAndtime.getValue() < this.interval) continue;
                gridJobManager.removeInterruptedJobInstance(jobInstanceIdAndtime.getKey());
            }
            logger.info("finished cleaning job instance map, size={}", (Object)gridJobManager.getInterruptedJobInstanceMap().size());
        }
        catch (Throwable throwable) {
            logger.error("failed to clean job instance map", throwable);
        }
    }
}

