/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.service;

import com.alibaba.dts.client.service.JobRunningException;
import com.alibaba.dts.client.service.JobRunningState;
import com.alibaba.dts.common.exception.InitException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JobRunningStateManager {
    private static JobRunningStateManager manageHandler = null;
    private static Long UPDATE_INTERVAL_TIME = 20000L;
    private static int MAX_EXCEPTION_NUM = 100;
    private Long lastUploadTime = System.currentTimeMillis();
    private ConcurrentHashMap<Long, JobRunningState> jobRunningStateMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, Long> jobInfoUploadTimeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, JobRunningException> jobRunningExceptionMap = new ConcurrentHashMap();

    public static synchronized JobRunningStateManager getManageHandler() {
        if (manageHandler == null) {
            manageHandler = new JobRunningStateManager();
        }
        return manageHandler;
    }

    public void init() throws InitException {
    }

    public void addJobRunningState(Long jobInstanceid, String stateDescribe) {
        this.jobRunningStateMap.put(jobInstanceid, new JobRunningState(stateDescribe, new Date()));
    }

    public void addJobRunningException(Long jobInstanceid, Throwable throwable) {
        Long deleteInstanceId;
        if (this.jobRunningExceptionMap.size() >= MAX_EXCEPTION_NUM && (deleteInstanceId = this.getMinInstanceId()) != null) {
            this.jobRunningExceptionMap.remove(deleteInstanceId);
        }
        this.jobRunningExceptionMap.put(jobInstanceid, new JobRunningException(throwable, new Date()));
    }

    public JobRunningState getJobRunningState(Long jobInstanceid) {
        return this.jobRunningStateMap.get(jobInstanceid);
    }

    public JobRunningException getJobRunningException(Long jobInstanceid) {
        return this.jobRunningExceptionMap.get(jobInstanceid);
    }

    public void deleteJobRunningState(Long jobInstanceid) {
        this.jobRunningStateMap.remove(jobInstanceid);
        this.jobInfoUploadTimeMap.remove(jobInstanceid);
    }

    public void deleteJobRunningException(Long jobInstanceid) {
        this.jobRunningExceptionMap.remove(jobInstanceid);
    }

    public String getJobRunningStateDescribe(Long jobInstanceid) {
        if (this.satisfiedTimeInterval(jobInstanceid)) {
            if (this.jobRunningStateMap.get(jobInstanceid) != null) {
                this.jobInfoUploadTimeMap.put(jobInstanceid, System.currentTimeMillis());
                return this.getJobRunningState(jobInstanceid).getDescribe();
            }
            return "NOTHING";
        }
        return "NOTHING";
    }

    private boolean satisfiedTimeInterval(Long jobInstanceid) {
        if (this.jobInfoUploadTimeMap.get(jobInstanceid) != null) {
            this.lastUploadTime = this.jobInfoUploadTimeMap.get(jobInstanceid);
        }
        return System.currentTimeMillis() - this.lastUploadTime >= UPDATE_INTERVAL_TIME;
    }

    public ConcurrentHashMap<Long, JobRunningState> getMap() {
        return this.jobRunningStateMap;
    }

    public void printMap() {
        for (Map.Entry<Long, JobRunningState> entry : this.jobRunningStateMap.entrySet()) {
            System.out.println("key:" + entry.getKey() + "," + "value:" + entry.getValue());
        }
    }

    private Long getMinInstanceId() {
        Long minInstanceId = Long.MAX_VALUE;
        if (this.jobRunningExceptionMap.isEmpty()) {
            return null;
        }
        for (Long instanceId : this.jobRunningExceptionMap.keySet()) {
            if (instanceId >= minInstanceId) continue;
            minInstanceId = instanceId;
        }
        return minInstanceId;
    }
}

