/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.store.access.impl;

import com.alibaba.dts.client.store.access.CommonDao;
import com.alibaba.dts.common.exception.AccessException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class CommonDaoH2
implements CommonDao {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(CommonDaoH2.class);
    private DataSource dataSource;

    public CommonDaoH2(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public int healthCheck() throws AccessException {
        int result = 0;
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("SELECT id FROM DTS_HEALTH_CHECK limit 1");
            preparedStatement.executeQuery();
        }
        catch (SQLException e) {
            throw new AccessException("[healthCheck]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    @Override
    public int createHealthCheckTable() throws AccessException {
        int result = 0;
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS `DTS_HEALTH_CHECK` (        `id` bigint(20) NOT NULL AUTO_INCREMENT,        PRIMARY KEY (`id`)        ) ; ");
            result = preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new AccessException("[createHealthCheckTable]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }
}

