/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.domain.alarm;

import com.alibaba.dts.common.domain.ProgressDetail;
import com.alibaba.dts.common.domain.alarm.AlarmProgressInfo;
import com.alibaba.dts.common.domain.alarm.InstanceToCheck;
import com.alibaba.dts.common.domain.alarm.JobAlarmInfo;
import com.alibaba.dts.common.domain.alarm.JobAlarmInfoEntity;
import com.alibaba.dts.common.domain.alarm.SendUserInfo;
import com.alibaba.dts.common.domain.alarm.WarningConfig;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.domain.store.WarningSetup;
import com.alibaba.dts.common.domain.store.assemble.AssembledMonitor;
import com.alibaba.dts.common.remoting.protocol.RemotingSerializable;
import com.alibaba.dts.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmDomainUtils {
    private static final Log log = LogFactory.getLog((String)"monitorInfo");
    private static final String NOT_FIRE_TIMES = "notFireTimes";
    private static final int NOT_FIRE_TIMES_LIMIT = 10000000;
    private static final String PHONE_REGEX = "^1[3|4|5|7|8][0-9]\\d{4,8}$";

    public static JobAlarmInfo convertToAlarmInfo(JobInstanceSnapshot instanceSnapshot) {
        JobAlarmInfo jobAlarmInfo = null;
        if (instanceSnapshot != null) {
            jobAlarmInfo = new JobAlarmInfo();
            jobAlarmInfo.setInstanceId(instanceSnapshot.getId());
            jobAlarmInfo.setJobId(instanceSnapshot.getJobId());
            jobAlarmInfo.setStatus(instanceSnapshot.getStatus());
            jobAlarmInfo.setJobDesc(instanceSnapshot.getDescription());
            jobAlarmInfo.setFireTime(instanceSnapshot.getFireTime());
            jobAlarmInfo.setJobType(instanceSnapshot.getJobType());
            AlarmProgressInfo progressInfo = new AlarmProgressInfo();
            if (StringUtils.isNotBlank(instanceSnapshot.getJobInstanceResult())) {
                try {
                    ProgressDetail progressDetail = RemotingSerializable.fromJson(instanceSnapshot.getJobInstanceResult(), ProgressDetail.class);
                    if (progressDetail != null && progressDetail.getTotalProgressBar() != null) {
                        progressInfo.setErrorRate(progressDetail.getTotalProgressBar().errorRate());
                        progressInfo.setFinishTime(progressDetail.getFinishTime());
                        progressInfo.setBlank(false);
                    }
                }
                catch (Throwable e) {
                    log.error((Object)("[AlarmDomainUtils]convertToAlarmInfo error, instanceSnapshotResult:" + instanceSnapshot.getJobInstanceResult()), e);
                }
            }
            jobAlarmInfo.setProgressInfo(progressInfo);
        }
        return jobAlarmInfo;
    }

    public static JobAlarmInfo convertToAlarmInfo(InstanceToCheck instanceToCheck) {
        JobAlarmInfo jobAlarmInfo = null;
        if (instanceToCheck != null) {
            jobAlarmInfo = new JobAlarmInfo();
            jobAlarmInfo.setInstanceId(instanceToCheck.getInstanceId());
            jobAlarmInfo.setJobId(instanceToCheck.getJobId());
            jobAlarmInfo.setStatus(instanceToCheck.getStatus());
            jobAlarmInfo.setJobDesc(instanceToCheck.getJobDesc());
            jobAlarmInfo.setFireTime(instanceToCheck.getFireTime());
            jobAlarmInfo.setJobType(instanceToCheck.getJobType());
            AlarmProgressInfo progressInfo = new AlarmProgressInfo();
            if (StringUtils.isNotBlank(instanceToCheck.getProgressInfo())) {
                try {
                    ProgressDetail progressDetail = RemotingSerializable.fromJson(instanceToCheck.getProgressInfo(), ProgressDetail.class);
                    if (progressDetail != null && progressDetail.getTotalProgressBar() != null) {
                        progressInfo.setErrorRate(progressDetail.getTotalProgressBar().errorRate());
                        progressInfo.setFinishTime(progressDetail.getFinishTime());
                        progressInfo.setBlank(false);
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"[AlarmDomainUtils]convertToAlarmInfo error.", e);
                }
            }
            jobAlarmInfo.setProgressInfo(progressInfo);
        }
        return jobAlarmInfo;
    }

    public static JobAlarmInfo convertToAlarmInfo(JobAlarmInfoEntity jobAlarmInfoEntity) {
        JobAlarmInfo jobAlarmInfo = null;
        if (jobAlarmInfoEntity != null) {
            jobAlarmInfo = new JobAlarmInfo();
            jobAlarmInfo.setInstanceId(jobAlarmInfoEntity.getInstanceId());
            jobAlarmInfo.setJobId(jobAlarmInfoEntity.getJobId());
            jobAlarmInfo.setStatus(jobAlarmInfoEntity.getStatus());
            jobAlarmInfo.setJobDesc(jobAlarmInfoEntity.getJobDesc());
            jobAlarmInfo.setFireTime(jobAlarmInfoEntity.getFireTime());
            jobAlarmInfo.setJobType(jobAlarmInfoEntity.getJobType());
            try {
                if (StringUtils.isNotBlank(jobAlarmInfoEntity.getProgressInfo())) {
                    AlarmProgressInfo alarmProgressInfo = (AlarmProgressInfo)JSON.parseObject((String)jobAlarmInfoEntity.getProgressInfo(), AlarmProgressInfo.class);
                    jobAlarmInfo.setProgressInfo(alarmProgressInfo);
                }
                if (StringUtils.isNotBlank(jobAlarmInfoEntity.getWarningConfig())) {
                    WarningConfig warningConfig = (WarningConfig)JSON.parseObject((String)jobAlarmInfoEntity.getWarningConfig(), WarningConfig.class);
                    jobAlarmInfo.setWarningConfig(warningConfig);
                }
            }
            catch (Throwable e) {
                log.error((Object)("[AlarmDomainUtils]convertToAlarmInfo error jobAlarmInfoEntity: " + jobAlarmInfoEntity), e);
            }
        }
        return jobAlarmInfo;
    }

    public static JobAlarmInfo convertToAlarmInfo(Job job) {
        JobAlarmInfo jobAlarmInfo = null;
        if (job != null) {
            jobAlarmInfo = new JobAlarmInfo();
            jobAlarmInfo.setJobId(job.getId());
            jobAlarmInfo.setJobDesc(job.getDescription());
            jobAlarmInfo.setCronExp(job.getCronExpression());
            jobAlarmInfo.setJobType(job.getType());
        }
        return jobAlarmInfo;
    }

    public static WarningConfig convertToConfig(WarningSetup warningSetup) {
        WarningConfig warningConfig = new WarningConfig();
        if (warningSetup != null) {
            try {
                JSONObject monitorConfig = JSON.parseObject((String)warningSetup.getWarningSetup());
                JSONArray contactConfig = JSON.parseArray((String)warningSetup.getContact());
                Pattern pattern = Pattern.compile(PHONE_REGEX);
                if (contactConfig != null && contactConfig.size() > 0) {
                    for (int i = 0; i < contactConfig.size(); ++i) {
                        Matcher matcher;
                        JSONObject json = (JSONObject)contactConfig.get(i);
                        if (json == null) continue;
                        SendUserInfo sendUserInfo = new SendUserInfo();
                        sendUserInfo.setEmpId(json.getString(WarningSetup.WWID));
                        if (StringUtils.isNotBlank(sendUserInfo.getEmpId()) && (matcher = pattern.matcher(sendUserInfo.getEmpId())).matches()) {
                            sendUserInfo.setMobile(sendUserInfo.getEmpId());
                        }
                        sendUserInfo.setEdasUserId(json.getString(WarningSetup.EDASID));
                        if (StringUtils.isNotBlank(sendUserInfo.getEdasUserId())) {
                            warningConfig.setMonitorEnv("edas");
                            sendUserInfo.setMobile(json.getString(WarningSetup.MOBILEID));
                            sendUserInfo.setEmail(json.getString(WarningSetup.EMAILID));
                        }
                        warningConfig.getUserInfos().add(sendUserInfo);
                    }
                } else if (StringUtils.isNotBlank(warningSetup.getContactPhone())) {
                    String[] emails;
                    String[] phones = warningSetup.getContactPhone().split(",");
                    if (phones != null && phones.length > 0) {
                        for (String phone : phones) {
                            SendUserInfo sendUserInfo = new SendUserInfo();
                            sendUserInfo.setMobile(phone);
                            warningConfig.getUserInfos().add(sendUserInfo);
                        }
                    }
                    if (StringUtils.isNotBlank(warningSetup.getContactEmail()) && (emails = warningSetup.getContactEmail().split(",")) != null && emails.length > 0) {
                        for (String email : emails) {
                            SendUserInfo sendUserInfo = new SendUserInfo();
                            sendUserInfo.setEmail(email);
                            warningConfig.getUserInfos().add(sendUserInfo);
                        }
                    }
                }
                if (monitorConfig != null) {
                    if (monitorConfig.getDoubleValue(WarningSetup.ERROR_RATE) > 0.0) {
                        warningConfig.setErrorRate(monitorConfig.getDoubleValue(WarningSetup.ERROR_RATE));
                        warningConfig.setErrorRateWarning(true);
                    }
                    if (monitorConfig.getLongValue(WarningSetup.TIMEOUT_LIMIT) > 0L) {
                        warningConfig.setTimeoutLimit(monitorConfig.getLongValue(WarningSetup.TIMEOUT_LIMIT));
                        warningConfig.setTimeoutWarning(true);
                    }
                    if (monitorConfig.getLongValue(NOT_FIRE_TIMES) > 0L && monitorConfig.getLongValue(NOT_FIRE_TIMES) < 10000000L) {
                        warningConfig.setNotFireTimes(monitorConfig.getLongValue(NOT_FIRE_TIMES));
                        warningConfig.setNotFireWarning(true);
                    }
                    warningConfig.setForcedTermination(monitorConfig.getBooleanValue(WarningSetup.FORCED_TERMINATION));
                    String deadLine = monitorConfig.getString(AssembledMonitor.DEADLINE);
                    if (StringUtils.isNotBlank(deadLine)) {
                        warningConfig.setDeadline(deadLine);
                        warningConfig.setDeadlineWarning(true);
                    }
                    if (AlarmDomainUtils.isOldVersion(monitorConfig)) {
                        warningConfig.setOldVersion(true);
                    } else {
                        warningConfig.setSmsWaring(monitorConfig.getBooleanValue(AssembledMonitor.SMS_WARING));
                        warningConfig.setEmailWaring(monitorConfig.getBooleanValue(AssembledMonitor.EMAIL_WARING));
                        warningConfig.setWwWaring(monitorConfig.getBooleanValue(AssembledMonitor.WW_WARING));
                        warningConfig.setDingWaring(monitorConfig.getBooleanValue(AssembledMonitor.DING_WARING));
                        warningConfig.setDisableWaring(monitorConfig.getBooleanValue(AssembledMonitor.DISABLE_WARING));
                    }
                }
            }
            catch (Throwable e) {
                log.error((Object)("[AlarmDomainUtils]convertToConfig error warningSetup: " + warningSetup), e);
            }
        }
        return warningConfig;
    }

    private static boolean isOldVersion(JSONObject warnConfig) {
        boolean result = true;
        if (warnConfig.containsKey((Object)AssembledMonitor.SMS_WARING)) {
            return false;
        }
        if (warnConfig.containsKey((Object)AssembledMonitor.WW_WARING)) {
            return false;
        }
        if (warnConfig.containsKey((Object)AssembledMonitor.EMAIL_WARING)) {
            return false;
        }
        if (warnConfig.containsKey((Object)AssembledMonitor.DING_WARING)) {
            return false;
        }
        if (warnConfig.containsKey((Object)AssembledMonitor.DISABLE_WARING)) {
            return false;
        }
        return result;
    }
}

