/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.remoting.netty;

import com.alibaba.dts.common.domain.remoting.Pair;
import com.alibaba.dts.common.exception.RemotingSendRequestException;
import com.alibaba.dts.common.exception.RemotingTimeoutException;
import com.alibaba.dts.common.exception.RemotingTooMuchRequestException;
import com.alibaba.dts.common.helper.RemotingHelper;
import com.alibaba.dts.common.remoting.ChannelEventListener;
import com.alibaba.dts.common.remoting.InvokeCallback;
import com.alibaba.dts.common.remoting.RPCHook;
import com.alibaba.dts.common.remoting.RemotingServer;
import com.alibaba.dts.common.remoting.netty.NettyDecoder;
import com.alibaba.dts.common.remoting.netty.NettyEncoder;
import com.alibaba.dts.common.remoting.netty.NettyEvent;
import com.alibaba.dts.common.remoting.netty.NettyEventType;
import com.alibaba.dts.common.remoting.netty.NettyRemotingAbstract;
import com.alibaba.dts.common.remoting.netty.NettyRequestProcessor;
import com.alibaba.dts.common.remoting.netty.NettyServerConfig;
import com.alibaba.dts.common.remoting.protocol.RemotingCommand;
import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.dts.shade.io.netty.bootstrap.ServerBootstrap;
import com.alibaba.dts.shade.io.netty.buffer.PooledByteBufAllocator;
import com.alibaba.dts.shade.io.netty.channel.Channel;
import com.alibaba.dts.shade.io.netty.channel.ChannelDuplexHandler;
import com.alibaba.dts.shade.io.netty.channel.ChannelFuture;
import com.alibaba.dts.shade.io.netty.channel.ChannelHandlerContext;
import com.alibaba.dts.shade.io.netty.channel.ChannelInitializer;
import com.alibaba.dts.shade.io.netty.channel.ChannelOption;
import com.alibaba.dts.shade.io.netty.channel.EventLoopGroup;
import com.alibaba.dts.shade.io.netty.channel.SimpleChannelInboundHandler;
import com.alibaba.dts.shade.io.netty.channel.nio.NioEventLoopGroup;
import com.alibaba.dts.shade.io.netty.channel.socket.SocketChannel;
import com.alibaba.dts.shade.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.alibaba.dts.shade.io.netty.handler.timeout.IdleState;
import com.alibaba.dts.shade.io.netty.handler.timeout.IdleStateEvent;
import com.alibaba.dts.shade.io.netty.handler.timeout.IdleStateHandler;
import com.alibaba.dts.shade.io.netty.util.concurrent.DefaultEventExecutorGroup;
import com.alibaba.dts.shade.io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NettyRemotingServer
extends NettyRemotingAbstract
implements RemotingServer {
    private static final Log log = LogFactory.getLog(NettyRemotingServer.class);
    protected final ServerBootstrap serverBootstrap;
    protected final EventLoopGroup eventLoopGroupWorker;
    protected final EventLoopGroup eventLoopGroupBoss;
    protected final NettyServerConfig nettyServerConfig;
    protected final ExecutorService publicExecutor;
    protected final ChannelEventListener channelEventListener;
    protected final Timer timer = new Timer("ServerHouseKeepingService", true);
    protected DefaultEventExecutorGroup defaultEventExecutorGroup;
    protected RPCHook rpcHook;
    protected int port = 0;

    public NettyRemotingServer(NettyServerConfig nettyServerConfig) {
        this(nettyServerConfig, null);
    }

    public NettyRemotingServer(final NettyServerConfig nettyServerConfig, ChannelEventListener channelEventListener) {
        super(nettyServerConfig.getServerOnewaySemaphoreValue(), nettyServerConfig.getServerAsyncSemaphoreValue());
        this.serverBootstrap = new ServerBootstrap();
        this.nettyServerConfig = nettyServerConfig;
        this.channelEventListener = channelEventListener;
        int publicThreadNums = nettyServerConfig.getServerCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        this.publicExecutor = Executors.newFixedThreadPool(publicThreadNums, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyServerPublicExecutor_" + this.threadIndex.incrementAndGet());
            }
        });
        this.eventLoopGroupBoss = new NioEventLoopGroup(1, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("NettyBossSelector_%d", this.threadIndex.incrementAndGet()));
            }
        });
        this.eventLoopGroupWorker = new NioEventLoopGroup(nettyServerConfig.getServerSelectorThreads(), new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);
            private int threadTotal = nettyServerConfig.getServerSelectorThreads();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("NettyServerSelector_%d_%d", this.threadTotal, this.threadIndex.incrementAndGet()));
            }
        });
    }

    @Override
    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyServerConfig.getServerWorkerThreads(), new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyServerWorkerThread_" + this.threadIndex.incrementAndGet());
            }
        });
        ServerBootstrap childHandler = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.eventLoopGroupBoss, this.eventLoopGroupWorker).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, 1024)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_KEEPALIVE, false)).childOption(ChannelOption.TCP_NODELAY, true).option(ChannelOption.SO_SNDBUF, this.nettyServerConfig.getServerSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, this.nettyServerConfig.getServerSocketRcvBufSize())).localAddress(new InetSocketAddress(this.nettyServerConfig.getListenPort()))).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast((EventExecutorGroup)NettyRemotingServer.this.defaultEventExecutorGroup, new NettyEncoder(), new NettyDecoder(), new IdleStateHandler(0, 0, NettyRemotingServer.this.nettyServerConfig.getServerChannelMaxIdleTimeSeconds()), new NettyConnetManageHandler(), new NettyServerHandler());
            }
        });
        if (this.nettyServerConfig.isServerPooledByteBufAllocatorEnable()) {
            childHandler.childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        }
        try {
            ChannelFuture sync = this.serverBootstrap.bind().sync();
            InetSocketAddress addr = (InetSocketAddress)sync.channel().localAddress();
            this.port = addr.getPort();
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("this.serverBootstrap.bind().sync() InterruptedException", e1);
        }
        if (this.channelEventListener != null) {
            this.nettyEventExecuter.start();
        }
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NettyRemotingServer.this.scanResponseTable();
                }
                catch (Exception e) {
                    log.error((Object)"scanResponseTable exception", (Throwable)e);
                }
            }
        }, 3000L, 1000L);
    }

    @Override
    public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair<NettyRequestProcessor, ExecutorService> pair = new Pair<NettyRequestProcessor, ExecutorService>(processor, executorThis);
        this.processorTable.put(requestCode, pair);
    }

    @Override
    public void registerDefaultProcessor(NettyRequestProcessor processor, ExecutorService executor) {
        this.defaultRequestProcessor = new Pair<NettyRequestProcessor, ExecutorService>(processor, executor);
    }

    @Override
    public RemotingCommand invokeSync(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
        return this.invokeSyncImpl(channel, request, timeoutMillis);
    }

    @Override
    public void invokeAsync(Channel channel, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
    }

    @Override
    public void invokeOneway(Channel channel, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        this.invokeOnewayImpl(channel, request, timeoutMillis);
    }

    @Override
    public void shutdown() {
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.eventLoopGroupBoss.shutdownGracefully();
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.nettyEventExecuter != null) {
                this.nettyEventExecuter.shutdown();
            }
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.error((Object)"NettyRemotingServer shutdown exception, ", (Throwable)e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                log.error((Object)"NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
    }

    @Override
    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    @Override
    public void registerRPCHook(RPCHook rpcHook) {
        this.rpcHook = rpcHook;
    }

    @Override
    public RPCHook getRPCHook() {
        return this.rpcHook;
    }

    @Override
    public int localListenPort() {
        return this.port;
    }

    class NettyConnetManageHandler
    extends ChannelDuplexHandler {
        NettyConnetManageHandler() {
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info((Object)("NETTY SERVER PIPELINE: channelRegistered {" + remoteAddress + "}"));
            super.channelRegistered(ctx);
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info((Object)("NETTY SERVER PIPELINE: channelUnregistered, the channel[{" + remoteAddress + "}]"));
            super.channelUnregistered(ctx);
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info((Object)("NETTY SERVER PIPELINE: channelActive, the channel[{" + remoteAddress + "}]"));
            super.channelActive(ctx);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.CONNECT, remoteAddress.toString(), ctx.channel()));
            }
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info((Object)("NETTY SERVER PIPELINE: channelInactive, the channel[{" + remoteAddress + "}]"));
            super.channelInactive(ctx);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress.toString(), ctx.channel()));
            }
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent evnet;
            if (evt instanceof IdleStateEvent && (evnet = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                log.warn((Object)("NETTY SERVER PIPELINE: IDLE exception [{" + remoteAddress + "}]"));
                RemotingUtil.closeChannel(ctx.channel());
                if (NettyRemotingServer.this.channelEventListener != null) {
                    NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.IDLE, remoteAddress.toString(), ctx.channel()));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.warn((Object)("NETTY SERVER PIPELINE: exceptionCaught {" + remoteAddress + "}"));
            log.warn((Object)"NETTY SERVER PIPELINE: exceptionCaught exception.", cause);
            if (NettyRemotingServer.this.channelEventListener != null) {
                NettyRemotingServer.this.putNettyEvent(new NettyEvent(NettyEventType.EXCEPTION, remoteAddress.toString(), ctx.channel()));
            }
            RemotingUtil.closeChannel(ctx.channel());
        }
    }

    class NettyServerHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        NettyServerHandler() {
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
            NettyRemotingServer.this.processMessageReceived(ctx, msg);
        }
    }
}

