/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.sdk.api;

import com.alibaba.dts.common.domain.ProgressDetail;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.sdk.api.Page;
import com.alibaba.dts.sdk.client.DtsHttpClient;
import com.alibaba.dts.sdk.context.SDKContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.schedulerx.common.domain.dto.JobDto;
import java.util.HashMap;
import java.util.List;

@Deprecated
public class JobApi {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(JobApi.class);
    private DtsHttpClient httpClient = new DtsHttpClient();
    private String host;
    public static final String PATH = "/schedulerx/sdkManager";
    public static final String CREATE_JOB_URL = "?action=JobAction&event_submit_do_create_job=1";
    public static final String GET_JOB_DETAIL_URL = "?action=JobAction&event_submit_do_get_job_detail=1";
    public static final String UPDATE_JOB_URL = "?action=JobAction&event_submit_do_edit_job=1";
    public static final String DELETE_JOB_URL = "?action=JobAction&event_submit_do_delete_job=1";
    public static final String ENABLE_JOB_URL = "?action=JobAction&event_submit_do_enable_job=1";
    public static final String DISABLE_JOB_URL = "?action=JobAction&event_submit_do_disable_job=1";
    public static final String START_JOB_URL = "?action=JobAction&event_submit_do_start_job=1";
    public static final String STOP_JOB_URL = "?action=JobAction&event_submit_do_stop_job=1";
    public static final String LIST_JOBS_URL = "?action=JobAction&event_submit_do_list_jobs=1";
    public static final String LIST_JOB_FIRE_RECORDS_URL = "?action=JobAction&event_submit_do_list_job_fire_records=1";

    public DtsHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(DtsHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getHost() {
        return this.host;
    }

    private void setHost(String host) {
        this.host = host;
    }

    public static JobApi getApi(String host, String userId) {
        JobApi api = new JobApi();
        api.setHost("http://" + host + PATH);
        SDKContext.setUserIdKey(userId);
        return api;
    }

    private JobApi() {
    }

    public void createJob(Job job) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("groupId", job.getEdasGroupId());
        map.put("clusterCode", String.valueOf(job.getClusterCode()));
        map.put("cronExpression", job.getCronExpression());
        map.put("jobProcessor", job.getJobProcessor());
        map.put("firePolicy", String.valueOf(job.getMaxInstanceAmount()));
        map.put("jobDesc", String.valueOf(job.getDescription()));
        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = this.httpClient.doPost(this.host + CREATE_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("\u521b\u5efaJob\u5931\u8d25");
        }
        try {
            Response response = this.parseResponse(rst);
            if (!response.isSuccess()) {
                logger.error(response.message);
                throw new RuntimeException("\u521b\u5efaJob\u5931\u8d25, " + response.message);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException("\u521b\u5efaJob\u5931\u8d25", e);
        }
    }

    public void deleteJob(long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = this.httpClient.doPost(this.host + DELETE_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("\u5220\u9664Job\u5931\u8d25");
        }
        try {
            Response response = this.parseResponse(rst);
            if (!response.isSuccess()) {
                logger.error(response.message);
                throw new RuntimeException("\u5220\u9664Job\u5931\u8d25, " + response.message);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException("\u5220\u9664Job\u5931\u8d25", e);
        }
    }

    public Page<JobDto> listJobs(String groupId, String clusterCode, String key, int page, int pageSize) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("creatorId", SDKContext.getUserIdKey());
        map.put("groupId", groupId);
        map.put("clusterCode", clusterCode);
        map.put("key", key);
        map.put("page", String.valueOf(page));
        map.put("pageSize", String.valueOf(pageSize));
        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = this.httpClient.doPost(this.host + LIST_JOBS_URL, map);
        if (rst == null) {
            throw new RuntimeException("\u67e5\u8be2Job\u5217\u8868\u5931\u8d25");
        }
        try {
            Response response = this.parseResponse(rst);
            if (!response.isSuccess()) {
                logger.error(response.message);
                throw new RuntimeException("\u67e5\u8be2Job\u5217\u8868\u5931\u8d25, " + response.message);
            }
            JSONObject jsonObject = JSON.parseObject((String)rst);
            Page page2 = (Page)JSON.parseObject((String)JSON.toJSONString((Object)jsonObject.getObject("data", Page.class)), (TypeReference)new TypeReference<Page<JobDto>>(){}, (Feature[])new Feature[0]);
            return this.buildPage(page2.getData(), page2.getTotal(), page, pageSize);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException("\u67e5\u8be2Job\u5217\u8868\u5931\u8d25", e);
        }
    }

    public Page<ProgressDetail> listJobFireRecords(long jobId, int page, int pageSize) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        map.put("page", String.valueOf(page));
        map.put("pageSize", String.valueOf(pageSize));
        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = this.httpClient.doPost(this.host + LIST_JOB_FIRE_RECORDS_URL, map);
        if (rst == null) {
            throw new RuntimeException("\u67e5\u8be2Job\u89e6\u53d1\u7eaa\u5f55\u5931\u8d25");
        }
        try {
            Response response = this.parseResponse(rst);
            if (!response.isSuccess()) {
                logger.error(response.message);
                throw new RuntimeException("\u67e5\u8be2Job\u89e6\u53d1\u7eaa\u5f55\u5931\u8d25, " + response.message);
            }
            JSONObject jsonObject = JSON.parseObject((String)rst);
            List historyRecords = (List)JSON.parseObject((String)((List)jsonObject.getObject("records", List.class)).toString(), (TypeReference)new TypeReference<List<ProgressDetail>>(){}, (Feature[])new Feature[0]);
            long total = jsonObject.getLong("total");
            return this.buildPage(historyRecords, total, page, pageSize);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException("\u67e5\u8be2Job\u89e6\u53d1\u7eaa\u5f55\u5931\u8d25", e);
        }
    }

    public JobDto getJobDetail(long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = this.httpClient.doPost(this.host + GET_JOB_DETAIL_URL, map);
        if (rst == null) {
            throw new RuntimeException("\u67e5\u8be2Job\u8be6\u60c5\u5931\u8d25");
        }
        try {
            Response response = this.parseResponse(rst);
            if (!response.isSuccess()) {
                logger.error(response.message);
                throw new RuntimeException("\u67e5\u8be2Job\u8be6\u60c5\u5931\u8d25, " + response.message);
            }
            JSONObject jsonObject = JSON.parseObject((String)rst);
            JobDto job = (JobDto)jsonObject.getObject("data", JobDto.class);
            return job;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException("\u67e5\u8be2Job\u8be6\u60c5\u5931\u8d25", e);
        }
    }

    public void editJob(Job job) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(job.getId()));
        map.put("jobType", String.valueOf(job.getType()));
        map.put("cronExpression", job.getCronExpression());
        map.put("jobProcessor", job.getJobProcessor());
        map.put("firePolicy", String.valueOf(job.getMaxInstanceAmount()));
        map.put("jobDesc", job.getDescription());
        map.put("jobArguments", job.getJobArguments());
        map.put("jobLevel", String.valueOf(job.getLevel()));
        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = this.httpClient.doPost(this.host + UPDATE_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("\u4fee\u6539job\u914d\u7f6e\u5931\u8d25");
        }
        try {
            Response response = this.parseResponse(rst);
            if (!response.isSuccess()) {
                logger.error(response.message);
                throw new RuntimeException("\u4fee\u6539job\u914d\u7f6e\u5931\u8d25, " + response.message);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException("\u4fee\u6539job\u914d\u7f6e\u5931\u8d25", e);
        }
    }

    public void enableJob(long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = this.httpClient.doPost(this.host + ENABLE_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("\u542f\u7528job\u5931\u8d25");
        }
        try {
            Response response = this.parseResponse(rst);
            if (!response.isSuccess()) {
                logger.error(response.message);
                throw new RuntimeException("\u542f\u7528job\u5931\u8d25, " + response.message);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException("\u542f\u7528job\u5931\u8d25", e);
        }
    }

    public void disableJob(long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = this.httpClient.doPost(this.host + DISABLE_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("\u505c\u7528job\u5931\u8d25");
        }
        try {
            Response response = this.parseResponse(rst);
            if (!response.isSuccess()) {
                logger.error(response.message);
                throw new RuntimeException("\u505c\u7528job\u5931\u8d25, " + response.message);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException("\u505c\u7528job\u5931\u8d25", e);
        }
    }

    public void startJob(String groupId, long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        map.put("groupId", String.valueOf(groupId));
        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = this.httpClient.doPost(this.host + START_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("\u89e6\u53d1job\u5931\u8d25");
        }
        try {
            Response response = this.parseResponse(rst);
            if (!response.isSuccess()) {
                logger.error(response.message);
                throw new RuntimeException("\u89e6\u53d1job\u5931\u8d25, " + response.message);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException("\u89e6\u53d1job\u5931\u8d25", e);
        }
    }

    public void stopJob(long jobId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("jobId", String.valueOf(jobId));
        SDKContext.setCookie("userIdKey=" + SDKContext.getUserIdKey());
        String rst = this.httpClient.doPost(this.host + STOP_JOB_URL, map);
        if (rst == null) {
            throw new RuntimeException("\u505c\u6b62job\u5931\u8d25");
        }
        try {
            Response response = this.parseResponse(rst);
            if (!response.isSuccess()) {
                logger.error(response.message);
                throw new RuntimeException("\u505c\u6b62job\u5931\u8d25, " + response.message);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException("\u505c\u6b62job\u5931\u8d25", e);
        }
    }

    private <T> Page<T> buildPage(List<T> data, long total, int pageNo, int pageSize) {
        Page<T> page = new Page<T>();
        page.setPage(pageNo);
        page.setPageSize(pageSize);
        page.setTotal(total);
        page.setData(data);
        return page;
    }

    private Response parseResponse(String response) {
        return (Response)JSON.parseObject((String)response, Response.class);
    }

    public static class Response<T> {
        private int code;
        private String message;
        private T data;
        private boolean success;

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public T getData() {
            return this.data;
        }

        public void setData(T data) {
            this.data = data;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }
    }
}

