/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.ali.dpath.util;

import com.alibaba.dts.shade.com.ali.dpath.DPath;
import com.alibaba.dts.shade.com.ali.dpath.util.ClassLoaderUtil;
import com.alibaba.dts.shade.com.taobao.middleware.logger.Level;
import com.alibaba.dts.shade.com.taobao.middleware.logger.Logger;
import com.alibaba.dts.shade.com.taobao.middleware.logger.LoggerFactory;
import java.util.ArrayList;

public class DPathLogger {
    private static Logger logger = LoggerFactory.getLogger(DPath.class);

    public static Logger logger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLogWithSizeRolling(int maxBackupIndex, String fileSize) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoaderUtil.switchContextLoader(DPathLogger.class.getClassLoader());
            int fileSizeInMB = Integer.valueOf(fileSize.substring(0, fileSize.length() - 2));
            String sizeType = fileSize.substring(fileSize.length() - 2);
            if ("GB".equals(sizeType)) {
                fileSizeInMB *= 1024;
            }
            logger.setLevel(Level.INFO);
            int hsfLogSize = (fileSizeInMB - 10 * maxBackupIndex) / maxBackupIndex;
            logger.activateAppenderWithSizeRolling("dpath", "dpath.log", "UTF-8", hsfLogSize + "MB", maxBackupIndex - 1);
            logger.setAdditivity(false);
            DPathLogger.activateAsync(logger, 2048, 0, false, 3000, true);
        }
        finally {
            ClassLoaderUtil.switchContextLoader(loader);
        }
    }

    private static void activateAsync(Logger logger, int queueSize, int discardingThreshold, boolean includeCallerData, int maxFlushTime, boolean neverBlock) {
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        args.add(new Object[]{"setQueueSize", new Class[]{Integer.TYPE}, queueSize});
        args.add(new Object[]{"setDiscardingThreshold", new Class[]{Integer.TYPE}, discardingThreshold});
        args.add(new Object[]{"setIncludeCallerData", new Class[]{Boolean.TYPE}, includeCallerData});
        args.add(new Object[]{"setMaxFlushTime", new Class[]{Integer.TYPE}, maxFlushTime});
        args.add(new Object[]{"setNeverBlock", new Class[]{Boolean.TYPE}, neverBlock});
        try {
            logger.activateAsync(args);
        }
        catch (Throwable e) {
            logger.warn("[HSF-LOGGER] activate async failed! Please use logback and upgrade logger.api to 0.2.3 or above" + e.getMessage());
        }
    }

    static {
        int maxBackupIndex = Integer.valueOf(System.getProperty("JM.LOG.RETAIN.COUNT", "2"));
        String fileSize = System.getProperty("JM.LOG.FILE.SIZE", "200MB");
        if (!fileSize.endsWith("MB") && !fileSize.endsWith("GB")) {
            throw new IllegalArgumentException("The value of JM.LOG.FILE.SIZE must end with MB or GB, such as 100MB");
        }
        DPathLogger.initLogWithSizeRolling(maxBackupIndex, fileSize);
    }
}

