/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.diamond.client.impl;

import com.alibaba.dts.shade.com.taobao.diamond.client.impl.DiamondEnv;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.HttpSimpleClient;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.ServerListManager;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.SpasAdapter;
import com.alibaba.dts.shade.com.taobao.diamond.utils.AppNameUtils;
import com.alibaba.dts.shade.com.taobao.middleware.logger.support.LoggerHelper;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ServerHttpAgent {
    public static final String appKey = System.getProperty("diamond.client.appKey", "");
    public static final String appName = AppNameUtils.getAppName();
    public static String serverPort = System.getProperty("diamond.server.port", "8080");
    public static String domainName = System.getProperty("address.server.domain", "jmenv.tbsite.net");
    public static String addressPort = System.getProperty("address.server.port", "8080");
    final ServerListManager serverListMgr;
    volatile String currentServerIp;

    ServerHttpAgent(ServerListManager mgr) {
        this.serverListMgr = mgr;
    }

    public HttpSimpleClient.HttpResult httpGet(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        String port = "8080";
        ArrayList<String> newHeaders = new ArrayList<String>();
        newHeaders.add("Spas-AccessKey");
        newHeaders.add(SpasAdapter.getAk());
        if (headers != null) {
            newHeaders.addAll(headers);
        }
        if (null != this.currentServerIp) {
            try {
                port = this.serverListMgr.getPortByIp(this.currentServerIp);
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(ServerHttpAgent.getUrl(this.currentServerIp, port, path), newHeaders, paramValues, encoding, readTimeoutMs);
                return result;
            }
            catch (ConnectException ce) {
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (SocketTimeoutException stoe) {
                DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (IOException ioe) {
                DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                throw ioe;
            }
        }
        Iterator<String> serverIter = this.serverListMgr.iterator();
        while (serverIter.hasNext()) {
            long timeout = endTime - System.currentTimeMillis();
            if (timeout <= 0L) {
                if (null != this.currentServerIp) {
                    DiamondEnv.log.error("the currentServerIp  which happened IOException in get(timeout) is: ", this.currentServerIp);
                }
                this.currentServerIp = serverIter.next();
                throw new IOException("timeout");
            }
            String ip = serverIter.next();
            try {
                port = this.serverListMgr.getPortByIp(ip);
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(ServerHttpAgent.getUrl(ip, port, path), newHeaders, paramValues, encoding, timeout);
                this.currentServerIp = ip;
                return result;
            }
            catch (ConnectException ce) {
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (SocketTimeoutException stoe) {
                DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (IOException ioe) {
                DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                throw ioe;
            }
        }
        DiamondEnv.log.error("Diamond-0002", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0002", "\u73af\u5883\u95ee\u9898", "no available server"));
        throw new ConnectException("no available server");
    }

    public HttpSimpleClient.HttpResult httpPost(String path, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        long endTime = System.currentTimeMillis() + readTimeoutMs;
        ArrayList<String> newHeaders = new ArrayList<String>();
        newHeaders.add("Spas-AccessKey");
        newHeaders.add(SpasAdapter.getAk());
        if (headers != null) {
            newHeaders.addAll(headers);
        }
        String port = "8080";
        if (null != this.currentServerIp) {
            try {
                port = this.serverListMgr.getPortByIp(this.currentServerIp);
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpPost(ServerHttpAgent.getUrl(this.currentServerIp, port, path), newHeaders, paramValues, encoding, readTimeoutMs);
                return result;
            }
            catch (ConnectException ce) {
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (SocketTimeoutException stoe) {
                DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (IOException ioe) {
                DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                throw ioe;
            }
        }
        Iterator<String> serverIter = this.serverListMgr.iterator();
        while (serverIter.hasNext()) {
            long timeout = endTime - System.currentTimeMillis();
            if (timeout <= 0L) {
                if (null != this.currentServerIp) {
                    DiamondEnv.log.error("the currentServerIp  which happened IOException(timeout) in post is: ", this.currentServerIp);
                }
                this.currentServerIp = serverIter.next();
                throw new IOException("timeout");
            }
            String ip = serverIter.next();
            try {
                port = this.serverListMgr.getPortByIp(ip);
                HttpSimpleClient.HttpResult result = HttpSimpleClient.httpPost(ServerHttpAgent.getUrl(ip, port, path), newHeaders, paramValues, encoding, timeout);
                this.currentServerIp = ip;
                return result;
            }
            catch (ConnectException ce) {
                DiamondEnv.log.error("Diamond ConnectException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (SocketTimeoutException stoe) {
                DiamondEnv.log.error("Diamond  SocketTimeoutException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
            }
            catch (IOException ioe) {
                DiamondEnv.log.error("Diamond  IOException", "currentServerIp:{},port:{}", new Object[]{this.currentServerIp, port});
                throw ioe;
            }
        }
        DiamondEnv.log.error("Diamond-0002", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0002", "\u73af\u5883\u95ee\u9898", "no available server"));
        throw new ConnectException("no available server");
    }

    static String getUrl(String ip, String port, String relativePath) {
        return "http://" + ip + ":" + port + "/diamond-server" + relativePath;
    }

    public void reSetCurrentServerIp() {
        if (this.currentServerIp != null) {
            this.currentServerIp = null;
        }
    }

    static {
        DiamondEnv.log.info("settings", "address-server domain:{} ,address-server port:{}", domainName, addressPort);
    }
}

