/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.diamond.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleFlowData {
    private int index = 0;
    private AtomicInteger[] data;
    private int average;
    private int slotCount;
    private ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("diamond flow control thread");
            t.setDaemon(true);
            return t;
        }
    });

    public SimpleFlowData(int slotCount, int interval) {
        this.slotCount = slotCount;
        this.data = new AtomicInteger[slotCount];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new AtomicInteger(0);
        }
        this.timer.scheduleAtFixedRate(new Runnable(){

            public void run() {
                SimpleFlowData.this.rotateSlot();
            }
        }, interval, interval, TimeUnit.MILLISECONDS);
    }

    public int addAndGet(int count) {
        return this.data[this.index].addAndGet(count);
    }

    public int incrementAndGet() {
        return this.data[this.index].incrementAndGet();
    }

    public void rotateSlot() {
        int total = 0;
        for (int i = 0; i < this.slotCount; ++i) {
            total += this.data[i].get();
        }
        this.average = total / this.slotCount;
        this.index = (this.index + 1) % this.slotCount;
        this.data[this.index].set(0);
    }

    public int getCurrentCount() {
        return this.data[this.index].get();
    }

    public int getAverageCount() {
        return this.average;
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    public String getSlotInfo() {
        StringBuilder sb = new StringBuilder();
        int index = this.index + 1;
        for (int i = 0; i < this.slotCount; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this.data[(i + index) % this.slotCount].get());
        }
        return sb.toString();
    }

    public int getCount(int prevStep) {
        int index = (this.index + this.slotCount - (prevStep %= this.slotCount)) % this.slotCount;
        return this.data[index].intValue();
    }
}

