/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.TraceLogger;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.EagleEyeJSONImpl;

class AtpTraceClient {
    private static final TraceLogger traceLogger = EagleEye.traceLogger("atp");
    private static final String DUMP_SIGN = "dump";
    private static final String DUMP_VALUE = "1";
    private static final char ATP_PARAM_SEPARATOR = '\u0012';
    private static final char ATP_OBJECT_SEPARATOR = '\u0014';
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    AtpTraceClient() {
    }

    public static void trace(String appId, String operationKey, Object obj, Object ... params) {
        AtpTraceClient.trace(DUMP_VALUE.equals(EagleEye.getUserData(DUMP_SIGN)), appId, operationKey, obj, params);
    }

    static void trace(boolean enabled, String appId, String operationKey, Object obj, Object ... params) {
        if (enabled && EagleEye.isLogDumpEnabled()) {
            StringBuilder appender = new StringBuilder(4096);
            try {
                if (null != params && params.length > 0) {
                    AtpTraceClient.appendObj(params[0], appender);
                    for (int i = 1; i < params.length; ++i) {
                        appender.append('\u0012');
                        AtpTraceClient.appendObj(params[i], appender);
                    }
                }
                appender.append('\u0014');
                AtpTraceClient.appendObj(obj, appender);
                traceLogger.logLine(appId, operationKey, appender.toString());
            }
            catch (Exception e) {
                EagleEye.selfLog("[WARN] AtpTraceClient exception, appId=" + appId + ", operationKey=" + operationKey, e);
            }
        }
    }

    private static void appendObj(Object obj, StringBuilder appender) {
        if (Void.TYPE == obj) {
            appender.append("VOID");
        } else if (null == obj) {
            appender.append("NULL");
        } else {
            appender.append(EagleEyeJSONImpl.toJSONString(obj));
        }
    }
}

