/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatEntry;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatEntryFunc;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatEntryFuncFactory;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatLogger;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

final class StatRollingData {
    private final StatLogger statLogger;
    private final ConcurrentHashMap<StatEntry, StatEntryFunc> statMap;
    private final long timeSlot;
    private final long rollingTimeMillis;
    private ReentrantLock insertLock = new ReentrantLock();
    private int entryCounter;

    StatRollingData(StatLogger statLogger, ConcurrentHashMap<StatEntry, StatEntryFunc> statMap, long timeSlot, long rollingTimeMillis) {
        this.statLogger = statLogger;
        this.statMap = statMap;
        this.timeSlot = timeSlot;
        this.rollingTimeMillis = rollingTimeMillis;
        this.entryCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatEntryFunc getStatEntryFunc(StatEntry statEntry, StatEntryFuncFactory factory) {
        StatEntryFunc func = this.statMap.get(statEntry);
        if (func == null) {
            StatEntryFunc newFunc = factory.create();
            boolean added = true;
            this.insertLock.lock();
            try {
                if (this.entryCounter < this.statLogger.getMaxEntryCount()) {
                    func = this.statMap.putIfAbsent(statEntry, newFunc);
                    if (func == null) {
                        func = newFunc;
                        ++this.entryCounter;
                    }
                } else {
                    added = false;
                }
            }
            finally {
                this.insertLock.unlock();
            }
            if (!added && (func = this.statMap.get(statEntry)) == null) {
                EagleEye.selfLog("[WARN] " + statEntry + " of StatLogger [" + this.statLogger.getLoggerName() + "] is not added since map is full: " + this.statMap.size());
                func = newFunc;
            }
        }
        return func;
    }

    StatLogger getStatLogger() {
        return this.statLogger;
    }

    long getRollingTimeMillis() {
        return this.rollingTimeMillis;
    }

    long getTimeSlot() {
        return this.timeSlot;
    }

    Set<Map.Entry<StatEntry, StatEntryFunc>> getStatEntrySet() {
        return this.statMap.entrySet();
    }
}

