/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeCoreUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

class TraceIdGenerator {
    private static String IP_16 = "ffffffff";
    private static String IP_int = "255255255255";
    private static String PID = "0000";
    private static char PID_FLAG = (char)100;
    private static final String regex = "\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b";
    private static final Pattern pattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
    private static AtomicInteger count = new AtomicInteger(1000);

    TraceIdGenerator() {
    }

    static String getHexPid(int pid) {
        if (pid < 0) {
            pid = 0;
        }
        if (pid > 65535) {
            String strPid = Integer.toString(pid);
            strPid = strPid.substring(strPid.length() - 4, strPid.length());
            pid = Integer.parseInt(strPid);
        }
        String str = Integer.toHexString(pid);
        while (str.length() < 4) {
            str = "0" + str;
        }
        return str;
    }

    static int getPid() {
        int pid;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        try {
            pid = Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (Exception e) {
            pid = 0;
        }
        return pid;
    }

    private static String getTraceId(String ip, long timestamp, int nextId) {
        StringBuilder appender = new StringBuilder(32);
        appender.append(ip).append(timestamp).append(nextId).append(PID_FLAG).append(PID);
        return appender.toString();
    }

    static String generate() {
        return TraceIdGenerator.getTraceId(IP_16, System.currentTimeMillis(), TraceIdGenerator.getNextId());
    }

    static String generate(String ip) {
        if (ip != null && !ip.isEmpty() && TraceIdGenerator.validate(ip)) {
            return TraceIdGenerator.getTraceId(TraceIdGenerator.getIP_16(ip), System.currentTimeMillis(), TraceIdGenerator.getNextId());
        }
        return TraceIdGenerator.generate();
    }

    static String generateIpv4Id() {
        return IP_int;
    }

    static String generateIpv4Id(String ip) {
        if (ip != null && !ip.isEmpty() && TraceIdGenerator.validate(ip)) {
            return TraceIdGenerator.getIP_int(ip);
        }
        return IP_int;
    }

    private static boolean validate(String ip) {
        try {
            return pattern.matcher(ip).matches();
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static String getIP_16(String ip) {
        String[] ips = ip.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (String column : ips) {
            String hex = Integer.toHexString(Integer.parseInt(column));
            if (hex.length() == 1) {
                sb.append('0').append(hex);
                continue;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private static String getIP_int(String ip) {
        return ip.replace(".", "");
    }

    private static int getNextId() {
        int next;
        int current;
        while (!count.compareAndSet(current, next = (current = count.get()) > 9000 ? 1000 : current + 1)) {
        }
        return next;
    }

    static {
        try {
            String ipAddress = EagleEyeCoreUtils.getLocalAddress();
            if (ipAddress != null) {
                IP_16 = TraceIdGenerator.getIP_16(ipAddress);
                IP_int = TraceIdGenerator.getIP_int(ipAddress);
            }
            PID = TraceIdGenerator.getHexPid(TraceIdGenerator.getPid());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

