/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.index;

import com.alibaba.dts.shade.org.h2.engine.Mode;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.index.Cursor;
import com.alibaba.dts.shade.org.h2.index.Index;
import com.alibaba.dts.shade.org.h2.index.IndexType;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.SearchRow;
import com.alibaba.dts.shade.org.h2.result.SortOrder;
import com.alibaba.dts.shade.org.h2.schema.SchemaObjectBase;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.IndexColumn;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.util.MathUtils;
import com.alibaba.dts.shade.org.h2.util.StatementBuilder;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueNull;

public abstract class BaseIndex
extends SchemaObjectBase
implements Index {
    protected IndexColumn[] indexColumns;
    protected Column[] columns;
    protected int[] columnIds;
    protected Table table;
    protected IndexType indexType;
    protected boolean isMultiVersion;

    protected void initBaseIndex(Table newTable, int id, String name, IndexColumn[] newIndexColumns, IndexType newIndexType) {
        this.initSchemaObjectBase(newTable.getSchema(), id, name, 5);
        this.indexType = newIndexType;
        this.table = newTable;
        if (newIndexColumns != null) {
            this.indexColumns = newIndexColumns;
            this.columns = new Column[newIndexColumns.length];
            int len = this.columns.length;
            this.columnIds = new int[len];
            for (int i = 0; i < len; ++i) {
                Column col;
                this.columns[i] = col = newIndexColumns[i].column;
                this.columnIds[i] = col.getColumnId();
            }
        }
    }

    protected static void checkIndexColumnTypes(IndexColumn[] columns) {
        for (IndexColumn c : columns) {
            int type = c.column.getType();
            if (type != 16 && type != 15) continue;
            throw DbException.getUnsupportedException("Index on BLOB or CLOB column: " + c.column.getCreateSQL());
        }
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    protected DbException getDuplicateKeyException(String key) {
        String sql = this.getName() + " ON " + this.table.getSQL() + "(" + this.getColumnListSQL() + ")";
        if (key != null) {
            sql = sql + " VALUES " + key;
        }
        DbException e = DbException.get(23505, sql);
        e.setSource(this);
        return e;
    }

    @Override
    public String getPlanSQL() {
        return this.getSQL();
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeIndex(this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public void replace(Session session, Row oldRow, Row newRow) {
        this.remove(session, oldRow);
        this.add(session, newRow);
    }

    @Override
    public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
        return this.find(filter.getSession(), first, last);
    }

    @Override
    public Cursor findNext(Session session, SearchRow higherThan, SearchRow last) {
        throw DbException.throwInternalError();
    }

    protected long getCostRangeIndex(int[] masks, long rowCount, TableFilter filter, SortOrder sortOrder) {
        long cost = rowCount += 1000L;
        long rows = rowCount;
        int totalSelectivity = 0;
        if (masks == null) {
            return cost;
        }
        int len = this.columns.length;
        for (int i = 0; i < len; ++i) {
            long distinctRows;
            Column column = this.columns[i];
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 1) == 1) {
                if (i == this.columns.length - 1 && this.getIndexType().isUnique()) {
                    cost = 3L;
                    break;
                }
                distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                if (distinctRows <= 0L) {
                    distinctRows = 1L;
                }
            } else {
                if ((mask & 6) == 6) {
                    cost = 2L + rows / 4L;
                    break;
                }
                if ((mask & 2) == 2) {
                    cost = 2L + rows / 3L;
                    break;
                }
                if ((mask & 4) != 4) break;
                cost = rows / 3L;
                break;
            }
            rows = Math.max(rowCount / distinctRows, 1L);
            cost = 2L + rows;
        }
        if (sortOrder != null) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypes();
            int len2 = sortTypes.length;
            for (int i = 0; i < len2 && i < this.indexColumns.length; ++i) {
                Column col = sortOrder.getColumn(i, filter);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = this.indexColumns[i];
                if (col != indexCol.column) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                cost -= (long)coveringCount;
            }
        }
        return cost;
    }

    @Override
    public int compareRows(SearchRow rowData, SearchRow compare) {
        if (rowData == compare) {
            return 0;
        }
        int len = this.indexColumns.length;
        for (int i = 0; i < len; ++i) {
            int index = this.columnIds[i];
            Value v1 = rowData.getValue(index);
            Value v2 = compare.getValue(index);
            if (v1 == null || v2 == null) {
                return 0;
            }
            int c = this.compareValues(v1, v2, this.indexColumns[i].sortType);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    protected boolean containsNullAndAllowMultipleNull(SearchRow newRow) {
        Mode mode = this.database.getMode();
        if (mode.uniqueIndexSingleNull) {
            return false;
        }
        if (mode.uniqueIndexSingleNullExceptAllColumnsAreNull) {
            for (int index : this.columnIds) {
                Value v = newRow.getValue(index);
                if (v == ValueNull.INSTANCE) continue;
                return false;
            }
            return true;
        }
        for (int index : this.columnIds) {
            Value v = newRow.getValue(index);
            if (v != ValueNull.INSTANCE) continue;
            return true;
        }
        return false;
    }

    int compareKeys(SearchRow rowData, SearchRow compare) {
        long k2;
        long k1 = rowData.getKey();
        if (k1 == (k2 = compare.getKey())) {
            if (this.isMultiVersion) {
                int v1 = rowData.getVersion();
                int v2 = compare.getVersion();
                return MathUtils.compareInt(v2, v1);
            }
            return 0;
        }
        return k1 > k2 ? 1 : -1;
    }

    private int compareValues(Value a, Value b, int sortType) {
        if (a == b) {
            return 0;
        }
        int comp = this.table.compareTypeSafe(a, b);
        if ((sortType & 1) != 0) {
            comp = -comp;
        }
        return comp;
    }

    @Override
    public int getColumnIndex(Column col) {
        int len = this.columns.length;
        for (int i = 0; i < len; ++i) {
            if (!this.columns[i].equals(col)) continue;
            return i;
        }
        return -1;
    }

    private String getColumnListSQL() {
        StatementBuilder buff = new StatementBuilder();
        for (IndexColumn c : this.indexColumns) {
            buff.appendExceptFirst(", ");
            buff.append(c.getSQL());
        }
        return buff.toString();
    }

    @Override
    public String getCreateSQLForCopy(Table targetTable, String quotedName) {
        StringBuilder buff = new StringBuilder("CREATE ");
        buff.append(this.indexType.getSQL());
        buff.append(' ');
        if (this.table.isHidden()) {
            buff.append("IF NOT EXISTS ");
        }
        buff.append(quotedName);
        buff.append(" ON ").append(targetTable.getSQL());
        if (this.comment != null) {
            buff.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        buff.append('(').append(this.getColumnListSQL()).append(')');
        return buff.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL());
    }

    @Override
    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void commit(int operation, Row row) {
    }

    void setMultiVersion(boolean multiVersion) {
        this.isMultiVersion = multiVersion;
    }

    @Override
    public Row getRow(Session session, long key) {
        throw DbException.getUnsupportedException(this.toString());
    }

    @Override
    public boolean isHidden() {
        return this.table.isHidden();
    }

    @Override
    public boolean isRowIdIndex() {
        return false;
    }

    @Override
    public boolean canScan() {
        return true;
    }

    @Override
    public void setSortedInsertMode(boolean sortedInsertMode) {
    }
}

