/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.mvstore.db;

import com.alibaba.dts.shade.org.h2.mvstore.DataUtils;
import com.alibaba.dts.shade.org.h2.mvstore.MVMap;
import com.alibaba.dts.shade.org.h2.mvstore.MVStore;
import com.alibaba.dts.shade.org.h2.mvstore.db.TransactionStore;
import com.alibaba.dts.shade.org.h2.mvstore.db.UndoLog;
import com.alibaba.dts.shade.org.h2.mvstore.type.DataType;
import com.alibaba.dts.shade.org.h2.mvstore.type.ObjectDataType;
import java.util.Map;
import java.util.Set;

public class MVUndoLog<K, V>
implements UndoLog<K, V> {
    private MVMap<K, V> map;

    public MVUndoLog(MVStore store, DataType dataType) {
        TransactionStore.VersionedValueType oldValueType = new TransactionStore.VersionedValueType(dataType);
        TransactionStore.ArrayType undoLogValueType = new TransactionStore.ArrayType(new DataType[]{new ObjectDataType(), dataType, oldValueType});
        MVMap.Builder builder = new MVMap.Builder().valueType(undoLogValueType);
        this.map = store.openMap("undoLog", builder);
        if (this.map.getValueType() != undoLogValueType) {
            throw DataUtils.newIllegalStateException(100, "Undo map open with a different value type", new Object[0]);
        }
    }

    private MVUndoLog(MVMap<K, V> map) {
        this.map = map;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }

    @Override
    public UndoLog<K, V> openVersion(long version) {
        MVMap<K, V> mapUsed = this.map.openVersion(version);
        return new MVUndoLog<K, V>(mapUsed);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public V remove(K key) {
        return this.map.remove(key);
    }

    @Override
    public K firstKey() {
        return this.map.firstKey();
    }

    @Override
    public K ceilingKey(K key) {
        return this.map.ceilingKey(key);
    }

    @Override
    public K floorKey(K key) {
        return this.map.floorKey(key);
    }

    @Override
    public K lowerKey(K key) {
        return this.map.lowerKey(key);
    }

    @Override
    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

