/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.table;

import com.alibaba.dts.shade.org.h2.command.Prepared;
import com.alibaba.dts.shade.org.h2.command.dml.Query;
import com.alibaba.dts.shade.org.h2.engine.DbObject;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.engine.User;
import com.alibaba.dts.shade.org.h2.expression.Alias;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.dts.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.dts.shade.org.h2.expression.Parameter;
import com.alibaba.dts.shade.org.h2.index.Index;
import com.alibaba.dts.shade.org.h2.index.IndexType;
import com.alibaba.dts.shade.org.h2.index.ViewIndex;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.LocalResult;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.SortOrder;
import com.alibaba.dts.shade.org.h2.schema.Schema;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.IndexColumn;
import com.alibaba.dts.shade.org.h2.table.PlanItem;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.util.New;
import com.alibaba.dts.shade.org.h2.util.SmallLRUCache;
import com.alibaba.dts.shade.org.h2.util.StatementBuilder;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import com.alibaba.dts.shade.org.h2.util.SynchronizedVerifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class TableView
extends Table {
    private static final long ROW_COUNT_APPROXIMATION = 100L;
    private String querySQL;
    private ArrayList<Table> tables;
    private String[] columnNames;
    private Query viewQuery;
    private ViewIndex index;
    private boolean recursive;
    private DbException createException;
    private final SmallLRUCache<CacheKey, ViewIndex> indexCache = SmallLRUCache.newInstance(64);
    private long lastModificationCheck;
    private long maxDataModificationId;
    private User owner;
    private Query topQuery;
    private LocalResult recursiveResult;
    private boolean tableExpression;

    public TableView(Schema schema, int id, String name, String querySQL, ArrayList<Parameter> params, String[] columnNames, Session session, boolean recursive) {
        super(schema, id, name, false, true);
        this.init(querySQL, params, columnNames, session, recursive);
    }

    public void replace(String querySQL, String[] columnNames, Session session, boolean recursive, boolean force) {
        String oldQuerySQL = this.querySQL;
        String[] oldColumnNames = this.columnNames;
        boolean oldRecursive = this.recursive;
        this.init(querySQL, null, columnNames, session, recursive);
        DbException e = this.recompile(session, force);
        if (e != null) {
            this.init(oldQuerySQL, null, oldColumnNames, session, oldRecursive);
            this.recompile(session, true);
            throw e;
        }
    }

    private synchronized void init(String querySQL, ArrayList<Parameter> params, String[] columnNames, Session session, boolean recursive) {
        this.querySQL = querySQL;
        this.columnNames = columnNames;
        this.recursive = recursive;
        this.index = new ViewIndex(this, querySQL, params, recursive);
        SynchronizedVerifier.check(this.indexCache);
        this.indexCache.clear();
        this.initColumnsAndTables(session);
    }

    private static Query compileViewQuery(Session session, String sql) {
        Prepared p = session.prepare(sql);
        if (!(p instanceof Query)) {
            throw DbException.getSyntaxError(sql, 0);
        }
        return (Query)p;
    }

    public synchronized DbException recompile(Session session, boolean force) {
        block5: {
            try {
                TableView.compileViewQuery(session, this.querySQL);
            }
            catch (DbException e) {
                if (force) break block5;
                return e;
            }
        }
        ArrayList<TableView> views = this.getViews();
        if (views != null) {
            views = New.arrayList(views);
        }
        SynchronizedVerifier.check(this.indexCache);
        this.indexCache.clear();
        this.initColumnsAndTables(session);
        if (views != null) {
            for (TableView v : views) {
                DbException e = v.recompile(session, force);
                if (e == null || force) continue;
                return e;
            }
        }
        return force ? null : this.createException;
    }

    private void initColumnsAndTables(Session session) {
        Column[] cols;
        block11: {
            this.removeViewFromTables();
            try {
                Query query = TableView.compileViewQuery(session, this.querySQL);
                this.querySQL = query.getPlanSQL();
                this.tables = New.arrayList(query.getTables());
                ArrayList<Expression> expressions = query.getExpressions();
                ArrayList<Column> list = New.arrayList();
                int count = query.getColumnCount();
                for (int i = 0; i < count; ++i) {
                    Expression checkExpression;
                    Expression aliasExpr;
                    Expression expr = expressions.get(i);
                    String name = null;
                    if (this.columnNames != null && this.columnNames.length > i) {
                        name = this.columnNames[i];
                    }
                    if (name == null) {
                        name = expr.getAlias();
                    }
                    int type = expr.getType();
                    long precision = expr.getPrecision();
                    int scale = expr.getScale();
                    int displaySize = expr.getDisplaySize();
                    Column col = new Column(name, type, precision, scale, displaySize);
                    col.setTable(this, i);
                    ExpressionColumn fromColumn = null;
                    if (expr instanceof ExpressionColumn) {
                        fromColumn = (ExpressionColumn)expr;
                    } else if (expr instanceof Alias && (aliasExpr = expr.getNonAliasExpression()) instanceof ExpressionColumn) {
                        fromColumn = (ExpressionColumn)aliasExpr;
                    }
                    if (fromColumn != null && (checkExpression = fromColumn.getColumn().getCheckConstraint(session, name)) != null) {
                        col.addCheckConstraint(session, checkExpression);
                    }
                    list.add(col);
                }
                cols = new Column[list.size()];
                list.toArray(cols);
                this.createException = null;
                this.viewQuery = query;
            }
            catch (DbException e) {
                e.addSQL(this.getCreateSQL());
                this.createException = e;
                this.tables = New.arrayList();
                cols = new Column[]{};
                if (!this.recursive || this.columnNames == null) break block11;
                cols = new Column[this.columnNames.length];
                for (int i = 0; i < this.columnNames.length; ++i) {
                    cols[i] = new Column(this.columnNames[i], 13);
                }
                this.index.setRecursive(true);
                this.createException = null;
            }
        }
        this.setColumns(cols);
        if (this.getId() != 0) {
            this.addViewToTables();
        }
    }

    public boolean isInvalid() {
        return this.createException != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlanItem getBestPlanItem(Session session, int[] masks, TableFilter filter, SortOrder sortOrder) {
        PlanItem item = new PlanItem();
        item.cost = this.index.getCost(session, masks, filter, sortOrder);
        CacheKey cacheKey = new CacheKey(masks, session);
        TableView tableView = this;
        synchronized (tableView) {
            SynchronizedVerifier.check(this.indexCache);
            ViewIndex i2 = (ViewIndex)this.indexCache.get(cacheKey);
            if (i2 != null) {
                item.setIndex(i2);
                return item;
            }
        }
        ViewIndex i2 = new ViewIndex(this, this.index, session, masks);
        TableView tableView2 = this;
        synchronized (tableView2) {
            ViewIndex i3 = (ViewIndex)this.indexCache.get(cacheKey);
            if (i3 != null) {
                item.setIndex(i3);
                return item;
            }
            this.indexCache.put(cacheKey, i2);
            item.setIndex(i2);
        }
        return item;
    }

    @Override
    public boolean isQueryComparable() {
        if (!super.isQueryComparable()) {
            return false;
        }
        for (Table t : this.tables) {
            if (t.isQueryComparable()) continue;
            return false;
        }
        return this.topQuery == null || this.topQuery.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR);
    }

    @Override
    public String getDropSQL() {
        return "DROP VIEW IF EXISTS " + this.getSQL() + " CASCADE";
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        return this.getCreateSQL(false, true, quotedName);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQL(false, true);
    }

    public String getCreateSQL(boolean orReplace, boolean force) {
        return this.getCreateSQL(orReplace, force, this.getSQL());
    }

    private String getCreateSQL(boolean orReplace, boolean force, String quotedName) {
        StatementBuilder buff = new StatementBuilder("CREATE ");
        if (orReplace) {
            buff.append("OR REPLACE ");
        }
        if (force) {
            buff.append("FORCE ");
        }
        buff.append("VIEW ");
        buff.append(quotedName);
        if (this.comment != null) {
            buff.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        if (this.columns != null && this.columns.length > 0) {
            buff.append('(');
            for (Column c : this.columns) {
                buff.appendExceptFirst(", ");
                buff.append(c.getSQL());
            }
            buff.append(')');
        } else if (this.columnNames != null) {
            buff.append('(');
            for (String n : this.columnNames) {
                buff.appendExceptFirst(", ");
                buff.append(n);
            }
            buff.append(')');
        }
        return buff.append(" AS\n").append(this.querySQL).toString();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean lock(Session session, boolean exclusive, boolean forceLockEvenInMvcc) {
        return false;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session s) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String indexName, int indexId, IndexColumn[] cols, IndexType indexType, boolean create, String indexComment) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void removeRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void addRow(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkSupportAlter() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public long getRowCount(Session session) {
        throw DbException.throwInternalError();
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public String getTableType() {
        return "VIEW";
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.removeViewFromTables();
        super.removeChildrenAndResources(session);
        this.database.removeMeta(session, this.getId());
        this.querySQL = null;
        this.index = null;
        this.invalidate();
    }

    @Override
    public String getSQL() {
        if (this.isTemporary()) {
            return "(\n" + StringUtils.indent(this.querySQL) + ")";
        }
        return super.getSQL();
    }

    public String getQuery() {
        return this.querySQL;
    }

    @Override
    public Index getScanIndex(Session session) {
        if (this.createException != null) {
            String msg = this.createException.getMessage();
            throw DbException.get(90109, this.createException, this.getSQL(), msg);
        }
        PlanItem item = this.getBestPlanItem(session, null, null, null);
        return item.getIndex();
    }

    @Override
    public boolean canReference() {
        return false;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return null;
    }

    @Override
    public long getMaxDataModificationId() {
        if (this.createException != null) {
            return Long.MAX_VALUE;
        }
        if (this.viewQuery == null) {
            return Long.MAX_VALUE;
        }
        long dbMod = this.database.getModificationDataId();
        if (dbMod > this.lastModificationCheck && this.maxDataModificationId <= dbMod) {
            this.maxDataModificationId = this.viewQuery.getMaxDataModificationId();
            this.lastModificationCheck = dbMod;
        }
        return this.maxDataModificationId;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    private void removeViewFromTables() {
        if (this.tables != null) {
            for (Table t : this.tables) {
                t.removeView(this);
            }
            this.tables.clear();
        }
    }

    private void addViewToTables() {
        for (Table t : this.tables) {
            t.addView(this);
        }
    }

    private void setOwner(User owner) {
        this.owner = owner;
    }

    public User getOwner() {
        return this.owner;
    }

    public static TableView createTempView(Session session, User owner, String name, Query query, Query topQuery) {
        Schema mainSchema = session.getDatabase().getSchema("PUBLIC");
        String querySQL = query.getPlanSQL();
        TableView v = new TableView(mainSchema, 0, name, querySQL, query.getParameters(), null, session, false);
        if (v.createException != null) {
            throw v.createException;
        }
        v.setTopQuery(topQuery);
        v.setOwner(owner);
        v.setTemporary(true);
        return v;
    }

    private void setTopQuery(Query topQuery) {
        this.topQuery = topQuery;
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    public int getParameterOffset() {
        return this.topQuery == null ? 0 : this.topQuery.getParameters().size();
    }

    @Override
    public boolean isDeterministic() {
        if (this.recursive || this.viewQuery == null) {
            return false;
        }
        return this.viewQuery.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR);
    }

    public void setRecursiveResult(LocalResult value) {
        if (this.recursiveResult != null) {
            this.recursiveResult.close();
        }
        this.recursiveResult = value;
    }

    public LocalResult getRecursiveResult() {
        return this.recursiveResult;
    }

    public void setTableExpression(boolean tableExpression) {
        this.tableExpression = tableExpression;
    }

    public boolean isTableExpression() {
        return this.tableExpression;
    }

    @Override
    public void addDependencies(HashSet<DbObject> dependencies) {
        super.addDependencies(dependencies);
        if (this.tables != null) {
            for (Table t : this.tables) {
                if ("VIEW".equals(t.getTableType())) continue;
                t.addDependencies(dependencies);
            }
        }
    }

    private static final class CacheKey {
        private final int[] masks;
        private final Session session;

        public CacheKey(int[] masks, Session session) {
            this.masks = masks;
            this.session = session;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.masks);
            result = 31 * result + this.session.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.session != other.session) {
                return false;
            }
            return Arrays.equals(this.masks, other.masks);
        }
    }
}

