/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.util;

import com.alibaba.dts.shade.org.h2.Driver;
import com.alibaba.dts.shade.org.h2.engine.Constants;
import com.alibaba.dts.shade.org.h2.jdbcx.JdbcDataSource;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.osgi.framework.BundleContext;
import org.osgi.service.jdbc.DataSourceFactory;

public class OsgiDataSourceFactory
implements DataSourceFactory {
    private Driver driver;

    public OsgiDataSourceFactory(Driver driver) {
        this.driver = driver;
    }

    public DataSource createDataSource(Properties properties) throws SQLException {
        Properties propertiesCopy = new Properties();
        if (properties != null) {
            propertiesCopy.putAll((Map<?, ?>)properties);
        }
        OsgiDataSourceFactory.rejectUnsupportedOptions(propertiesCopy);
        OsgiDataSourceFactory.rejectPoolingOptions(propertiesCopy);
        JdbcDataSource dataSource = new JdbcDataSource();
        OsgiDataSourceFactory.setupH2DataSource(dataSource, propertiesCopy);
        return dataSource;
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties properties) throws SQLException {
        Properties propertiesCopy = new Properties();
        if (properties != null) {
            propertiesCopy.putAll((Map<?, ?>)properties);
        }
        OsgiDataSourceFactory.rejectUnsupportedOptions(propertiesCopy);
        OsgiDataSourceFactory.rejectPoolingOptions(propertiesCopy);
        JdbcDataSource dataSource = new JdbcDataSource();
        OsgiDataSourceFactory.setupH2DataSource(dataSource, propertiesCopy);
        return dataSource;
    }

    public XADataSource createXADataSource(Properties properties) throws SQLException {
        Properties propertiesCopy = new Properties();
        if (properties != null) {
            propertiesCopy.putAll((Map<?, ?>)properties);
        }
        OsgiDataSourceFactory.rejectUnsupportedOptions(propertiesCopy);
        OsgiDataSourceFactory.rejectPoolingOptions(propertiesCopy);
        JdbcDataSource dataSource = new JdbcDataSource();
        OsgiDataSourceFactory.setupH2DataSource(dataSource, propertiesCopy);
        return dataSource;
    }

    public java.sql.Driver createDriver(Properties properties) throws SQLException {
        if (properties != null && !properties.isEmpty()) {
            throw new SQLException();
        }
        return this.driver;
    }

    private static void rejectUnsupportedOptions(Properties p) throws SQLFeatureNotSupportedException {
        if (p.containsKey("roleName")) {
            throw new SQLFeatureNotSupportedException("The roleName property is not supported by H2");
        }
        if (p.containsKey("dataSourceName")) {
            throw new SQLFeatureNotSupportedException("The dataSourceName property is not supported by H2");
        }
    }

    private static void setupH2DataSource(JdbcDataSource dataSource, Properties p) {
        if (p.containsKey("user")) {
            dataSource.setUser((String)p.remove("user"));
        }
        if (p.containsKey("password")) {
            dataSource.setPassword((String)p.remove("password"));
        }
        if (p.containsKey("description")) {
            dataSource.setDescription((String)p.remove("description"));
        }
        StringBuffer connectionUrl = new StringBuffer();
        if (p.containsKey("url")) {
            connectionUrl.append(p.remove("url"));
            p.remove("networkProtocol");
            p.remove("serverName");
            p.remove("portNumber");
            p.remove("databaseName");
        } else {
            connectionUrl.append("jdbc:h2:");
            String protocol = "";
            if (p.containsKey("networkProtocol")) {
                protocol = (String)p.remove("networkProtocol");
                connectionUrl.append(protocol).append(":");
            }
            if (p.containsKey("serverName")) {
                connectionUrl.append("//").append(p.remove("serverName"));
                if (p.containsKey("portNumber")) {
                    connectionUrl.append(":").append(p.remove("portNumber"));
                }
                connectionUrl.append("/");
            } else if (p.containsKey("portNumber")) {
                connectionUrl.append("//localhost:").append(p.remove("portNumber")).append("/");
            } else if (protocol.equals("tcp") || protocol.equals("ssl")) {
                connectionUrl.append("//localhost/");
            }
            if (p.containsKey("databaseName")) {
                connectionUrl.append(p.remove("databaseName"));
            }
        }
        for (Object option : p.keySet()) {
            connectionUrl.append(";").append(option).append("=").append(p.get(option));
        }
        if (connectionUrl.length() > "jdbc:h2:".length()) {
            dataSource.setURL(connectionUrl.toString());
        }
    }

    private static void rejectPoolingOptions(Properties p) throws SQLFeatureNotSupportedException {
        if (p.containsKey("initialPoolSize") || p.containsKey("maxIdleTime") || p.containsKey("maxPoolSize") || p.containsKey("maxStatements") || p.containsKey("minPoolSize") || p.containsKey("propertyCycle")) {
            throw new SQLFeatureNotSupportedException("Pooling properties are not supported by H2");
        }
    }

    static void registerService(BundleContext bundleContext, Driver driver) {
        Properties properties = new Properties();
        properties.put("osgi.jdbc.driver.class", Driver.class.getName());
        properties.put("osgi.jdbc.driver.name", "H2 JDBC Driver");
        properties.put("osgi.jdbc.driver.version", Constants.getFullVersion());
        bundleContext.registerService(DataSourceFactory.class.getName(), (Object)new OsgiDataSourceFactory(driver), (Dictionary)properties);
    }
}

