/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.remoting.processor;

import com.alibaba.dts.shade.io.netty.channel.ChannelHandlerContext;
import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.common.context.InvocationContext;
import com.alibaba.tmq.common.domain.remoting.protocol.InvokeMethod;
import com.alibaba.tmq.common.domain.result.ResultCode;
import com.alibaba.tmq.common.exception.InitException;
import com.alibaba.tmq.common.helper.RemotingHelper;
import com.alibaba.tmq.common.monitor.callback.Display;
import com.alibaba.tmq.common.remoting.netty.NettyRequestProcessor;
import com.alibaba.tmq.common.remoting.protocol.RemotingCommand;
import com.alibaba.tmq.common.util.BytesUtil;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientRequestProcessor
extends ClientContext
implements NettyRequestProcessor {
    private static final Log logger = LogFactory.getLog(ClientRequestProcessor.class);
    private LinkedBlockingQueue<Runnable> requestQueue = null;

    public ClientRequestProcessor(LinkedBlockingQueue<Runnable> requestQueue) {
        this.requestQueue = requestQueue;
    }

    public void init() throws InitException {
        clientMonitor.addDisplay(new Display(){

            @Override
            public String content() {
                return "requestQueue > size:" + ClientRequestProcessor.this.requestQueue.size() + ", remainingCapacity:" + ClientRequestProcessor.this.requestQueue.remainingCapacity();
            }
        });
    }

    @Override
    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        long startTime = System.currentTimeMillis();
        byte[] requestBody = request.getBody();
        if (null == requestBody) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error((Object)("[ClientRequestProcessor]: requestBody is null, remoteAddress:" + remoteAddress));
            return new RemotingCommand();
        }
        InvokeMethod invokeMethod = null;
        try {
            invokeMethod = (InvokeMethod)BytesUtil.bytesToObject(requestBody);
        }
        catch (Throwable e) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error((Object)("[ClientRequestProcessor]: bytesToObject error, remoteAddress:" + remoteAddress), e);
            return new RemotingCommand();
        }
        if (null == invokeMethod) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error((Object)("[ClientRequestProcessor]: invokeMethod is null, remoteAddress:" + remoteAddress));
            return new RemotingCommand();
        }
        invokeMethod.reversal();
        invokeMethod.getConnectionChannel().setChannel(ctx.channel());
        InvocationContext.setConnectionChannel(invokeMethod.getConnectionChannel());
        Object result = proxyService.invokeMethod(clientService, invokeMethod.getMethodName(), invokeMethod.getParameterTypes(), invokeMethod.getArguments());
        InvocationContext.clean();
        if (null == result) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error((Object)("[ClientRequestProcessor]: result is null, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod));
            return new RemotingCommand();
        }
        if (ResultCode.NO_SUCH_METHOD.equals(result)) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error((Object)("[ClientRequestProcessor]: NO_SUCH_METHOD, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod));
            byte[] resultBody = null;
            try {
                resultBody = BytesUtil.objectToBytes(ResultCode.NO_SUCH_METHOD.toJsonString());
            }
            catch (Throwable e) {
                logger.error((Object)("[ClientRequestProcessor]: NO_SUCH_METHOD objectToBytes error, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod), e);
            }
            RemotingCommand response = new RemotingCommand();
            response.setBody(resultBody);
            return response;
        }
        byte[] responseBody = null;
        try {
            responseBody = BytesUtil.objectToBytes(result);
        }
        catch (Throwable e) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error((Object)("[ClientRequestProcessor]: objectToBytes error, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod), e);
            return new RemotingCommand();
        }
        RemotingCommand response = new RemotingCommand();
        response.setBody(responseBody);
        clientMonitor.methodCount(invokeMethod.getMethodName(), startTime);
        return response;
    }
}

