/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.monitor.timer;

import com.alibaba.tmq.common.domain.remoting.Pair;
import com.alibaba.tmq.common.monitor.callback.Display;
import com.alibaba.tmq.common.util.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;

public class MethodCountTimer
extends TimerTask {
    private final Log logger;
    private final List<Display> displayList;
    private final ConcurrentHashMap<String, Pair<AtomicLong, AtomicLong>> methodCountTable;

    public MethodCountTimer(Log logger, List<Display> displayList, ConcurrentHashMap<String, Pair<AtomicLong, AtomicLong>> methodCountTable) {
        this.logger = logger;
        this.displayList = displayList;
        this.methodCountTable = methodCountTable;
    }

    @Override
    public void run() {
        StringBuilder counterLog = new StringBuilder("display start\n\n");
        if (this.displayList != null && this.displayList.size() > 0) {
            for (Display display : this.displayList) {
                counterLog.append(" " + display.content() + "\n");
            }
            counterLog.append("\n");
        }
        ArrayList<String> header = new ArrayList<String>();
        String key = "method name";
        header.add("invoke per second");
        header.add("response time (ms)");
        HashMap<String, List<String>> body = new HashMap<String, List<String>>();
        Iterator<Map.Entry<String, Pair<AtomicLong, AtomicLong>>> iterator = this.methodCountTable.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry<String, Pair<AtomicLong, AtomicLong>> entry = iterator.next();
                String methodName = entry.getKey();
                Pair<AtomicLong, AtomicLong> countPair = entry.getValue();
                AtomicLong counter = countPair.getObject1();
                AtomicLong totalTime = countPair.getObject2();
                ArrayList<String> itemList = new ArrayList<String>();
                itemList.add(counter.toString());
                itemList.add(String.valueOf(0L == counter.get() ? 0L : totalTime.get() / counter.get()));
                body.put(methodName, itemList);
                counter.set(0L);
                totalTime.set(0L);
            }
            catch (Throwable e) {
                this.logger.error((Object)"[MethodCountTimer]: count error", e);
            }
        }
        counterLog.append(LoggerUtil.displayTable(key, header, body) + "\n\n\n");
        this.logger.info((Object)counterLog.toString());
    }
}

