/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.util;

import com.alibaba.tmq.common.constants.Constants;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeUtil
implements Constants {
    private static final Log logger = LogFactory.getLog(TimeUtil.class);

    public static String date2SecondsString(Date date) {
        return TimeUtil.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String date2MilliSeconds(Date date) {
        return TimeUtil.format(date, "yyyy-MM-dd HH:mm:ss.SSS");
    }

    public static String format(Date date, String format) {
        SimpleDateFormat formater = new SimpleDateFormat(format);
        return formater.format(date);
    }

    public static String format(String date, String sourceFormat, String targetFormat) {
        return TimeUtil.format(TimeUtil.string2Date(date, sourceFormat), targetFormat);
    }

    public static Date string2Date(String date) {
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return formater.parse(date);
        }
        catch (Throwable e) {
            logger.error((Object)("[TimeUtil]: string2Date error, date:" + date), e);
            return null;
        }
    }

    public static Date string2Date(String date, String format) {
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            return formater.parse(date);
        }
        catch (Throwable e) {
            logger.error((Object)("[TimeUtil]: string2Date error, date:" + date + ", format:" + format), e);
            return null;
        }
    }

    public static Date date2Seconds(Date date) {
        return TimeUtil.string2Date(TimeUtil.format(date, "yyyy-MM-dd HH:mm:ss"));
    }

    public static Date date2Minute(Date date) {
        return TimeUtil.string2Date(TimeUtil.format(date, "yyyy-MM-dd HH:mm"), "yyyy-MM-dd HH:mm");
    }

    public static Date increaseDate(Date date, int field, int amount) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, amount);
        return calendar.getTime();
    }

    public static int getTimeInterval(int initDelay, double increaseRate, int retryCount) {
        return (int)((double)initDelay + (double)retryCount * increaseRate * (double)initDelay);
    }
}

