package com.aliyun.openservices.ons.sasl.client;

import com.sun.security.sasl.util.PolicyUtils;

import javax.security.auth.callback.*;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import java.io.IOException;
import java.util.Map;


public class OnsSaslClientFactory implements SaslClientFactory {
   private static final String[] myMechs = new String[]{OnsSaslClient.ONS_MECHANISM};
    private static final int[] mechPolicies = new int[]{7, 17, 16};

    public OnsSaslClientFactory() {
    }


    public SaslClient createSaslClient(
            String[] mechanisms,
            String authorizationId,
            String protocol,
            String serverName,
            Map<String,?> props,
            CallbackHandler cbh) throws SaslException {
        if (mechanisms.length != 1 || !mechanisms[0].equals(OnsSaslClient.ONS_MECHANISM)) {
            throw new SaslException("OnsSaslClientFactory only support mechanism:" + OnsSaslClient.ONS_MECHANISM);
        }


        Object[] paras = this.getUserInfo(OnsSaslClient.ONS_MECHANISM, authorizationId, cbh);
        return new OnsSaslClient(authorizationId, (String)paras[0], (String)paras[1]);
    }

    public String[] getMechanismNames(Map<String, ?> props) {
        return PolicyUtils.filterMechs(myMechs, mechPolicies, props);
    }

    private Object[] getUserInfo(String mechanism, String authorizationID, CallbackHandler callback) throws SaslException {
        if(callback == null) {
            throw new SaslException("Callback handler to get username/password required");
        } else {
            try {
                String namePrompt = mechanism + " authentication id: ";
                String passwordPrompt = mechanism + " password: ";
                NameCallback nameCallBack = authorizationID == null?new NameCallback(namePrompt):new NameCallback(namePrompt, authorizationID);
                PasswordCallback passwdCallBack = new PasswordCallback(passwordPrompt, false);
                callback.handle(new Callback[]{nameCallBack, passwdCallBack});
                char[] pwdBytes = passwdCallBack.getPassword();

                String password = null;
                if(pwdBytes != null) {
                    password = new String(pwdBytes);
                    passwdCallBack.clearPassword();
                }

                String username = nameCallBack.getName();
                return new Object[]{username, password};
            } catch (IOException var11) {
                throw new SaslException("Cannot get password", var11);
            } catch (UnsupportedCallbackException var12) {
                throw new SaslException("Cannot get userid/password", var12);
            }
        }
    }
}

