package com.aliyun.openservices.ons.sasl.client;

import java.lang.reflect.Method;
import java.util.Properties;

public class SaslUtil {

    public static byte[] join(byte sep, byte[]... args) {
        int len = args.length - 1;
        for (byte[] arg : args) {
            len += arg.length;
        }
        byte[] bytes = new byte[len];

        int pos = 0;
        for (int i = 0; i < args.length; i++) {
            if (i != 0) {
                bytes[pos++] = sep;
            }
            System.arraycopy(args[i], 0, bytes, pos, args[i].length);
            pos += args[i].length;
        }
        return bytes;
    }

    public static void properties2Object(final Properties p, final Object object) {
        Method[] methods = object.getClass().getMethods();
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.startsWith("set")) {
                continue;
            }
            try {
                String tmp = methodName.substring(4);
                String first = methodName.substring(3, 4);
                String key = first.toLowerCase() + tmp;
                String property = p.getProperty(key);
                if (property != null) {
                    Class<?>[] pt = method.getParameterTypes();
                    if (pt != null && pt.length > 0) {
                        String className = pt[0].getSimpleName();
                        Object arg = null;
                        if (className.equals("int")|| className.equals("Integer")) {
                            arg = Integer.parseInt(property);
                        } else if (className.equals("long")|| className.equals("Long")) {
                            arg = Long.parseLong(property);
                        } else if (className.equals("double")|| className.equals("Double")) {
                            arg = Double.parseDouble(property);
                        } else if (className.equals("boolean")|| className.equals("Boolean")) {
                            arg = Boolean.parseBoolean(property);
                        } else if (className.equals("float")|| className.equals("Float")) {
                            arg = Float.parseFloat(property);
                        }else if (className.equals("String")) {
                            arg = property;
                        }else {
                            continue;
                        }
                        method.invoke(object, new Object[]{arg});
                    }
                }
            } catch (Throwable e) {
            }
        }
    }
}
