/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.mail.impl;

import com.blazebit.mail.Mail;
import com.blazebit.mail.MailException;
import com.blazebit.mail.MailResource;
import com.blazebit.mail.MailSender;
import com.blazebit.mail.MailTransport;
import com.blazebit.mail.MailUtil;
import com.blazebit.mail.Recipient;
import com.blazebit.mail.impl.SimplePasswordAuthenticator;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class SimpleMailSender
implements MailSender {
    private static final Logger log = Logger.getLogger(SimpleMailSender.class.getName());
    private Session session;
    private MailTransport transport;

    public SimpleMailSender(Session session) {
        this.session = session;
    }

    public SimpleMailSender(String host, Integer port, String username, String password) {
        this(host, port, username, password, MailTransport.SMTP);
    }

    public SimpleMailSender(String host, Integer port, String username, String password, MailTransport transport) {
        if (host == null || host.trim().equals("")) {
            throw new MailException("Can't send an email without host");
        }
        if (password != null && !password.trim().equals("") && (username == null || username.trim().equals(""))) {
            throw new MailException("Can't have a password without username");
        }
        this.transport = transport;
        this.session = this.createMailSession(host, port, username, password);
    }

    public Session createMailSession(String host, Integer port, String username, String password) {
        if (this.transport == null) {
            log.warning("MailTransport not set, using plain SMTP strategy instead!");
            this.transport = MailTransport.SMTP;
        }
        Properties props = this.transport.getDefaultProperties();
        props.put(this.transport.getHostProperty(), host);
        if (port != null) {
            props.put(this.transport.getPortProperty(), String.valueOf(port));
        } else if (this.transport.getDefaultPort() != null) {
            props.put(this.transport.getPortProperty(), String.valueOf(this.transport.getDefaultPort()));
        }
        if (username != null) {
            props.put(this.transport.getUserProperty(), username);
        }
        if (password != null) {
            props.put(this.transport.getPasswordProperty(), password);
            props.put(this.transport.getAuthentificationProperty(), "true");
            return Session.getInstance((Properties)props, (Authenticator)new SimplePasswordAuthenticator(username, password));
        }
        return Session.getInstance((Properties)props);
    }

    public void setDebug(boolean debug) {
        this.session.setDebug(debug);
    }

    @Override
    public void sendMail(Mail email) throws MailException {
        this.sendMail(email, this.transport);
    }

    @Override
    public void sendMail(Mail email, MailTransport transport) throws MailException {
        if (MailUtil.validate(email)) {
            try {
                Message message = this.prepareMessage(email);
                message.saveChanges();
                Transport t = this.session.getTransport(transport.getProtocol());
                t.connect();
                t.sendMessage(message, message.getAllRecipients());
                t.close();
            }
            catch (UnsupportedEncodingException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new MailException(String.format("Encoding not accepted: %s", e.getMessage()));
            }
            catch (MessagingException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new MailException(String.format("Generic error: %s", e.getMessage()), e);
            }
            finally {
                transport.clearTemporaryTrustedHosts();
            }
        }
    }

    private Message prepareMessage(Mail email) throws MessagingException, UnsupportedEncodingException {
        MimeMultipart multipartRoot = new MimeMultipart("mixed");
        MimeBodyPart contentRelated = new MimeBodyPart();
        MimeMultipart multipartRelated = new MimeMultipart("related");
        MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
        MimeMultipart multipartAlternativeMessages = new MimeMultipart("alternative");
        multipartRoot.addBodyPart((BodyPart)contentRelated);
        contentRelated.setContent((Multipart)multipartRelated);
        multipartRelated.addBodyPart((BodyPart)contentAlternativeMessages);
        contentAlternativeMessages.setContent((Multipart)multipartAlternativeMessages);
        MimeMessage message = new MimeMessage(this.session);
        message.setSubject(email.getSubject());
        message.setFrom((Address)new InternetAddress(email.getFrom().getAddress(), email.getFrom().getName()));
        this.setReplyTo(email, (Message)message);
        this.setRecipients(email, (Message)message);
        this.setTexts(email, multipartAlternativeMessages);
        this.setEmbeddedImages(email, multipartRelated);
        this.setAttachments(email, multipartRoot);
        message.setContent((Multipart)multipartRoot);
        this.setHeaders(email, (Message)message);
        message.setSentDate(new Date());
        return message;
    }

    private void setRecipients(Mail email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Recipient recipient : email.getRecipients()) {
            InternetAddress address = new InternetAddress(recipient.getAddress(), recipient.getName());
            message.addRecipient(recipient.getType(), (Address)address);
        }
    }

    private void setReplyTo(Mail email, Message message) throws UnsupportedEncodingException, MessagingException {
        Recipient replyToRecipient = email.getReplyTo();
        if (replyToRecipient != null) {
            InternetAddress replyToAddress = new InternetAddress(replyToRecipient.getAddress(), replyToRecipient.getName());
            message.setReplyTo(new Address[]{replyToAddress});
        }
    }

    private void setTexts(Mail email, MimeMultipart multipartAlternativeMessages) throws MessagingException {
        if (email.getText() != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(email.getText(), "UTF-8");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePart);
        }
        if (email.getHtml() != null) {
            MimeBodyPart messagePartHTML = new MimeBodyPart();
            messagePartHTML.setContent((Object)email.getHtml(), "text/html; charset=\"UTF-8\"");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartHTML);
        }
    }

    private void setEmbeddedImages(Mail email, MimeMultipart multipartRelated) throws MessagingException {
        for (MailResource embeddedImage : email.getEmbeddedImages()) {
            multipartRelated.addBodyPart(this.getBodyPartFromDatasource(embeddedImage, "inline"));
        }
    }

    private void setAttachments(Mail email, MimeMultipart multipartRoot) throws MessagingException {
        for (MailResource resource : email.getAttachments()) {
            multipartRoot.addBodyPart(this.getBodyPartFromDatasource(resource, "attachment"));
        }
    }

    private void setHeaders(Mail email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Map.Entry<String, String> header : email.getHeaders().entrySet()) {
            String headerName = header.getKey();
            String headerValue = MimeUtility.encodeText((String)header.getValue(), (String)"UTF-8", null);
            String foldedHeaderValue = MimeUtility.fold((int)(headerName.length() + 2), (String)headerValue);
            message.addHeader(header.getKey(), foldedHeaderValue);
        }
    }

    private BodyPart getBodyPartFromDatasource(MailResource resource, String dispositionType) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        DataSource ds = resource.getDataSource();
        attachmentPart.setDataHandler(new DataHandler(resource.getDataSource()));
        attachmentPart.setFileName(resource.getName());
        attachmentPart.setHeader("Content-Type", ds.getContentType() + "; filename=" + ds.getName() + "; name=" + ds.getName());
        attachmentPart.setHeader("Content-ID", String.format("<%s>", ds.getName()));
        attachmentPart.setDisposition(dispositionType + "; size=0");
        return attachmentPart;
    }
}

