/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.mail.transport;

import com.blazebit.mail.transport.MailSSLSocketFactory;
import com.blazebit.mail.transport.SmtpMailTransport;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class SmtpsMailTransport
extends SmtpMailTransport {
    private MailSSLSocketFactory fact;

    public SmtpsMailTransport() {
        try {
            this.fact = new MailSSLSocketFactory();
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalArgumentException("Could not initialize socketFactory!", ex);
        }
    }

    @Override
    public Integer getDefaultPort() {
        return 465;
    }

    @Override
    public boolean isSecure() {
        return true;
    }

    @Override
    public void addTrustedHost(String host, boolean permanently) {
        this.fact.addTrustedHost(host, permanently);
    }

    @Override
    public void removeTrustedHost(String host) {
        this.fact.removeTrustedHost(host);
    }

    @Override
    public void clearTemporaryTrustedHosts() {
        this.fact.clearTemporaryTrustedHosts();
    }

    @Override
    public List<String> getTemporaryTrustedHosts() {
        return this.fact.getTemporaryTrustedHosts();
    }

    @Override
    public List<String> getTrustedHosts() {
        return Collections.unmodifiableList(Arrays.asList(this.fact.getTrustedHosts()));
    }

    @Override
    public void setTrustAllHosts(boolean trustAllHosts) {
        this.fact.setTrustAllHosts(trustAllHosts);
    }

    @Override
    public boolean isTrustAllHosts() {
        return this.fact.isTrustAllHosts();
    }

    @Override
    public Properties getDefaultProperties() {
        Properties props = super.getDefaultProperties();
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.ssl.enable", "true");
        props.put("mail.smtp.socketFactory", this.fact);
        props.put("mail.smtp.ssl.socketFactory", this.fact);
        return props;
    }
}

