/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.compiler;

import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.compiler.EmbedFunc;
import com.centit.support.compiler.Formula;
import com.centit.support.compiler.Lexer;
import com.centit.support.compiler.VariableTranslate;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public abstract class Pretreatment {
    private Pretreatment() {
        throw new IllegalAccessError("Utility class");
    }

    public static String objectToFormulaString(Object objValue) {
        if (objValue == null) {
            return "\"\"";
        }
        if (objValue instanceof Object[]) {
            Object[] objs = (Object[])objValue;
            if (objs.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < objs.length; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    if (objs[i] == null) continue;
                    if (ReflectionOpt.isNumberType(objs[i].getClass())) {
                        sb.append(objs[i].toString());
                        continue;
                    }
                    if (objs[i] instanceof Date) {
                        sb.append(StringRegularOpt.quotedString((String)DatetimeOpt.convertDatetimeToString((Date)((Date)objs[i]))));
                        continue;
                    }
                    sb.append(StringRegularOpt.quotedString((String)objs[i].toString()));
                }
                return sb.toString();
            }
            return "\"\"";
        }
        if (objValue instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            int vc = 0;
            Collection valueList = (Collection)objValue;
            for (Object ov : valueList) {
                if (ov == null) continue;
                if (vc > 0) {
                    sb.append(",");
                }
                if (ReflectionOpt.isNumberType(ov.getClass())) {
                    sb.append(ov.toString());
                } else if (ov instanceof Date) {
                    sb.append(StringRegularOpt.quotedString((String)DatetimeOpt.convertDatetimeToString((Date)((Date)ov))));
                } else {
                    sb.append(StringRegularOpt.quotedString((String)ov.toString()));
                }
                ++vc;
            }
            if (vc == 0) {
                return "\"\"";
            }
            return sb.toString();
        }
        if (objValue instanceof Date) {
            return StringRegularOpt.quotedString((String)DatetimeOpt.convertDatetimeToString((Date)((Date)objValue)));
        }
        return StringRegularOpt.quotedString((String)objValue.toString());
    }

    public static String runPretreatment(String szFormula, VariableTranslate varTrans) {
        Lexer varMorp = new Lexer();
        varMorp.setFormula(szFormula);
        StringBuilder sDesFormula = new StringBuilder();
        String sWord = varMorp.getAWord();
        while (sWord != null && !sWord.equals("")) {
            if (sWord.equals("$")) {
                sWord = varMorp.getAWord();
                if (sWord.equals("{")) {
                    sWord = varMorp.getStringUntil("}");
                    sDesFormula.append(Pretreatment.objectToFormulaString(varTrans.getLabelValue(sWord))).append(" ");
                } else {
                    sDesFormula.append("$" + sWord + " ");
                }
            } else if (Lexer.isLabel(sWord) && !Formula.isKeyWord(sWord) && EmbedFunc.getFuncNo(sWord) == -1) {
                sDesFormula.append(Pretreatment.objectToFormulaString(varTrans.getLabelValue(sWord))).append(" ");
            } else {
                sDesFormula.append(sWord).append(" ");
            }
            sWord = varMorp.getAWord();
        }
        return sDesFormula.toString();
    }

    public static String mapTemplateString(String template, Object object, String nullValue) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return nullValue;
        }
        Lexer varTemplate = new Lexer();
        varTemplate.setFormula(template);
        StringBuilder mapString = new StringBuilder();
        int nlen = template.length();
        int bp = 0;
        while (varTemplate.seekTo('{')) {
            int ep = varTemplate.getCurrPos();
            if (ep - 1 > bp) {
                mapString.append(template.substring(bp, ep - 1));
            }
            varTemplate.seekToRightBrace();
            bp = varTemplate.getCurrPos();
            if (bp - 1 <= ep) continue;
            String valueName = template.substring(ep, bp - 1);
            mapString.append((String)GeneralAlgorithm.nvl((Object)StringBaseOpt.objectToString((Object)ReflectionOpt.attainExpressionValue((Object)object, (String)valueName)), (Object)nullValue));
        }
        if (bp < nlen) {
            mapString.append(template.substring(bp));
        }
        return mapString.toString();
    }

    public static String mapTemplateString(String template, Object object) {
        return Pretreatment.mapTemplateString(template, object, null);
    }
}

