/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.DatetimeOpt;
import java.util.Date;
import java.util.function.Function;

public class CachedIdentifiedObject<K, T> {
    private T target;
    private boolean evicted;
    private Date refreshTime;
    private long freshPeriod;
    private Function<K, T> refresher;

    public CachedIdentifiedObject(Function<K, T> refresher, T target, long freshPeriod) {
        assert (target != null) : "\u8f93\u5165\u7684 target \u503c\u4e0d\u80fd\u4e3anull ";
        this.target = target;
        this.evicted = false;
        this.refreshTime = DatetimeOpt.currentUtilDate();
        this.refresher = refresher;
        this.freshPeriod = freshPeriod;
    }

    public CachedIdentifiedObject(Function<K, T> refresher, long freshPeriod) {
        this.target = null;
        this.evicted = true;
        this.refresher = refresher;
        this.freshPeriod = freshPeriod;
    }

    public CachedIdentifiedObject(Function<K, T> refresher) {
        this(refresher, 43200L);
    }

    public void setFreshPeriod(int freshPeriod) {
        this.freshPeriod = freshPeriod;
    }

    public synchronized void evictObject() {
        this.evicted = true;
    }

    public synchronized T getCachedObject(K key) {
        if (this.target == null || this.evicted || System.currentTimeMillis() > this.refreshTime.getTime() + this.freshPeriod * 60000L) {
            this.target = this.refresher.apply(key);
            this.refreshTime = DatetimeOpt.currentUtilDate();
            this.evicted = false;
        }
        return this.target;
    }
}

