/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.common.CachedIdentifiedObject;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class CachedMap<K, T> {
    private ConcurrentMap<K, CachedIdentifiedObject<K, T>> targetMap;
    private Date refreshTime;
    private long freshPeriod;
    private Function<K, T> refresher;

    public CachedMap(Function<K, T> refresher, long freshPeriod, int initialCapacity) {
        this.targetMap = new ConcurrentHashMap<K, CachedIdentifiedObject<K, T>>(initialCapacity);
        this.refresher = refresher;
        this.freshPeriod = freshPeriod;
    }

    public CachedMap(Function<K, T> refresher) {
        this(refresher, 43200L, 16);
    }

    public CachedMap(Function<K, T> refresher, int initialCapacity) {
        this(refresher, 43200L, initialCapacity);
    }

    public void setFreshPeriod(int freshPeriod) {
        this.freshPeriod = freshPeriod;
    }

    public synchronized void evictObject(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            identifiedObject.evictObject();
        }
    }

    public synchronized T getCachedObject(K key) {
        CachedIdentifiedObject identifiedObject = (CachedIdentifiedObject)this.targetMap.get(key);
        if (identifiedObject != null) {
            return identifiedObject.getCachedObject(key);
        }
        T target = this.refresher.apply(key);
        if (target != null) {
            this.targetMap.put(key, new CachedIdentifiedObject<K, T>(this.refresher, target, this.freshPeriod));
        }
        return target;
    }
}

