/*
 * Decompiled with CFR 0.152.
 */
package com.centit.support.common;

import com.centit.support.algorithm.ReflectionOpt;
import com.centit.support.common.JavaBeanField;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JavaBeanMetaData {
    private Class<?> javaType;
    private Map<String, JavaBeanField> fileds;

    private JavaBeanMetaData() {
    }

    private JavaBeanMetaData(Class<?> javaType) {
        this.javaType = javaType;
        this.fileds = new HashMap<String, JavaBeanField>(30);
    }

    public static JavaBeanMetaData createBeanMetaDataFromType(Class<?> javaType) {
        List<Method> getters;
        Field[] objFields;
        JavaBeanMetaData metaData = new JavaBeanMetaData(javaType);
        for (Field field : objFields = javaType.getDeclaredFields()) {
            metaData.getFileds().put(field.getName(), new JavaBeanField(field));
        }
        List<Method> setters = ReflectionOpt.getAllSetterMethod(javaType);
        if (setters != null) {
            for (Method md : setters) {
                String fieldName = StringUtils.uncapitalize((String)md.getName().substring(3));
                JavaBeanField javaField = metaData.getFiled(fieldName);
                if (javaField == null) {
                    javaField = new JavaBeanField();
                    javaField.setSetFieldValueFunc(md);
                    javaField.setFieldType(md.getParameterTypes()[0]);
                    metaData.getFileds().put(fieldName, javaField);
                    continue;
                }
                if (!javaField.isAssignableFrom(md.getParameterTypes()[0])) continue;
                javaField.setSetFieldValueFunc(md);
            }
        }
        if ((getters = ReflectionOpt.getAllGetterMethod(javaType)) != null) {
            for (Method md : getters) {
                String fieldName = StringUtils.uncapitalize((String)md.getName().substring(3));
                JavaBeanField javaField = metaData.getFiled(fieldName);
                if (javaField == null) {
                    javaField = new JavaBeanField();
                    javaField.setGetFieldValueFunc(md);
                    javaField.setFieldType(md.getReturnType());
                    metaData.getFileds().put(fieldName, javaField);
                    continue;
                }
                if (!javaField.isAssignableFrom(md.getReturnType())) continue;
                javaField.setGetFieldValueFunc(md);
            }
        }
        return metaData;
    }

    public Object createBeanObject() throws IllegalAccessException, InstantiationException {
        return this.javaType.newInstance();
    }

    public Object createBeanObjectFromMap(Map<String, Object> properties) throws IllegalAccessException, InstantiationException {
        Object object = this.javaType.newInstance();
        for (Map.Entry<String, Object> pro : properties.entrySet()) {
            this.setObjectFieldValue(object, pro.getKey(), pro.getValue());
        }
        return object;
    }

    public void setObjectFieldValue(Object object, String fieldName, Object newValue) {
        JavaBeanField field = this.getFiled(fieldName);
        if (field == null) {
            return;
        }
        field.setObjectFieldValue(object, newValue);
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public Map<String, JavaBeanField> getFileds() {
        return this.fileds;
    }

    public JavaBeanField getFiled(String fieldName) {
        return this.fileds.get(fieldName);
    }
}

