/*
 * Decompiled with CFR 0.152.
 */
package me.geso.routes;

import java.util.LinkedHashMap;
import java.util.List;
import me.geso.routes.PathRoute;
import me.geso.routes.RoutingResult;

public class HttpRoute<T> {
    private final PathRoute<T> pathRoute;
    private final List<String> methods;

    public String toString() {
        return "HttpRoute [pathRoute=" + this.pathRoute + ", methods=" + this.methods + "]";
    }

    public HttpRoute(String path, T destination, List<String> methods) {
        this.pathRoute = new PathRoute<T>(path, destination);
        this.methods = methods;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public T getDestination() {
        return this.pathRoute.getDestination();
    }

    public String getPath() {
        return this.pathRoute.getPath();
    }

    public RoutingResult<T> match(String method, String path) {
        LinkedHashMap<String, String> captured = new LinkedHashMap<String, String>();
        if (this.pathRoute.match(path, captured)) {
            boolean methodAllowed = this.methods.contains(method);
            return new RoutingResult<T>(methodAllowed, this.pathRoute.getDestination(), captured);
        }
        return null;
    }
}

