/*
 * Decompiled with CFR 0.152.
 */
package me.geso.routes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.geso.routes.HttpRoute;
import me.geso.routes.RoutingResult;

public class WebRouter<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<HttpRoute<T>> patterns = new ArrayList<HttpRoute<T>>();

    public String toString() {
        return "WebRouter [patterns=" + this.getPatterns() + "]";
    }

    public boolean isEmpty() {
        return this.getPatterns().isEmpty();
    }

    public RoutingResult<T> match(String method, String path) {
        RoutingResult<T> routingResult = null;
        for (HttpRoute<T> route : this.getPatterns()) {
            RoutingResult<T> result = route.match(method, path);
            if (result == null || !(routingResult = result).methodAllowed()) continue;
            return routingResult;
        }
        return routingResult;
    }

    public WebRouter<T> get(String path, T destination) {
        return this.addRoute(path, destination, Arrays.asList("GET", "HEAD"));
    }

    public WebRouter<T> post(String path, T destination) {
        return this.addRoute(path, destination, Arrays.asList("POST"));
    }

    public WebRouter<T> addRoute(String path, T destination, List<String> methods) {
        this.getPatterns().add(new HttpRoute<T>(path, destination, methods));
        return this;
    }

    public List<HttpRoute<T>> getPatterns() {
        return this.patterns;
    }
}

