/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.quartz.job.http;

import com.blazebit.quartz.job.AbstractJob;
import com.blazebit.quartz.job.JobParameter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class AbstractHttpInvokerJob
extends AbstractJob {
    private static final long serialVersionUID = 1L;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap map = context.getMergedJobDataMap();
        String url = this.getRequiredParam(map, "url");
        String urlSuffix = this.getOptionalParam(map, "urlSuffix");
        String parameterEncoding = "UTF-8";
        StringBuilder urlBuilder = new StringBuilder(url);
        if (urlSuffix != null) {
            if (!url.endsWith("/") && !urlSuffix.startsWith("/")) {
                urlBuilder.append("/");
            }
            urlBuilder.append(urlSuffix);
        }
        URLConnection con = null;
        InputStream is = null;
        try {
            StringBuilder data = new StringBuilder();
            for (Map.Entry<String, Object> entry : this.getUndefinedParameters(map).entrySet()) {
                if (data.length() != 0) {
                    data.append("&");
                }
                data.append(URLEncoder.encode(entry.getKey(), parameterEncoding));
                data.append("=");
                data.append(URLEncoder.encode(entry.getValue().toString(), parameterEncoding));
            }
            con = this.createConnection(urlBuilder.toString(), data.toString());
            con.connect();
            is = con.getInputStream();
            this.handleResponse(is);
        }
        catch (MalformedURLException ex) {
            throw new JobExecutionException("Invalid URL given", (Throwable)ex, false);
        }
        catch (FileNotFoundException ex) {
            throw new JobExecutionException("URL can not be reached", (Throwable)ex, false);
        }
        catch (IOException ex) {
            throw new JobExecutionException("Error occured during the invocation of the URL", (Throwable)ex, false);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    @Override
    public List<JobParameter> getParameters() {
        ArrayList<JobParameter> params = new ArrayList<JobParameter>(super.getParameters());
        params.add(new JobParameter("url", true, String.class));
        params.add(new JobParameter("urlSuffix", false, String.class));
        return params;
    }

    protected abstract URLConnection createConnection(String var1, String var2) throws IOException;

    protected void handleResponse(InputStream is) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
    }
}

