/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Collectors;

public final class IOKit {
    private IOKit() {
        throw new IllegalStateException("IOKit shouldn't be constructed!");
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readToString(String file) throws IOException {
        BufferedReader crunchifyBufferReader = Files.newBufferedReader(Paths.get(file, new String[0]));
        return crunchifyBufferReader.lines().collect(Collectors.joining());
    }

    public static String readToString(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingFileChannels(File source, File dest) throws IOException {
        FileChannel inputChannel = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            inputChannel = new FileInputStream(source).getChannel();
            outputChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)outputChannel).transferFrom(inputChannel, 0L, inputChannel.size());
        }
        finally {
            assert (inputChannel != null);
            inputChannel.close();
            assert (outputChannel != null);
            outputChannel.close();
        }
    }
}

