/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class ReflectKit {
    private static final List EMPTY_LIST = new ArrayList(0);

    public static <T> T newInstance(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object convert(Class<?> type, String value) {
        if (type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == String.class) {
            return value;
        }
        if (type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == Short.class) {
            return Short.parseShort(value);
        }
        return value;
    }

    public static Object invokeMehod(Object bean, Method method, Object ... args) throws Exception {
        int argCount;
        Class<?>[] types = method.getParameterTypes();
        int n = argCount = args == null ? 0 : args.length;
        if (argCount != types.length) {
            throw new IllegalStateException(String.format("%s in %s", method.getName(), bean));
        }
        for (int i = 0; i < argCount; ++i) {
            args[i] = ReflectKit.cast(args[i], types[i]);
        }
        return method.invoke(bean, args);
    }

    public static <T> T cast(Object value, Class<T> type) {
        if (value != null && !type.isAssignableFrom(value.getClass())) {
            if (ReflectKit.is(type, Integer.TYPE, Integer.class)) {
                value = Integer.parseInt(value.toString());
            } else if (ReflectKit.is(type, Long.TYPE, Long.class)) {
                value = Long.parseLong(value.toString());
            } else if (ReflectKit.is(type, Float.TYPE, Float.class)) {
                value = Float.valueOf(Float.parseFloat(value.toString()));
            } else if (ReflectKit.is(type, Double.TYPE, Double.class)) {
                value = Double.parseDouble(value.toString());
            } else if (ReflectKit.is(type, Boolean.TYPE, Boolean.class)) {
                value = Boolean.parseBoolean(value.toString());
            } else if (ReflectKit.is(type, String.class)) {
                value = value.toString();
            }
        }
        return (T)value;
    }

    public static boolean is(Object obj, Object ... mybe) {
        if (obj != null && mybe != null) {
            for (Object mb : mybe) {
                if (!obj.equals(mb)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasInterface(Class<?> cls, Class<?> inter) {
        return Stream.of(cls.getInterfaces()).filter(c -> c.equals(inter)).count() > 0L;
    }

    public static boolean isNormalClass(Class<?> cls) {
        return !cls.isInterface() && !Modifier.isAbstract(cls.getModifiers());
    }

    public static Method getMethod(Class<?> cls, String methodName, Class<?> ... types) {
        try {
            return cls.getMethod(methodName, types);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isPrimitive(Class<?> cls) {
        return cls == Boolean.TYPE || cls == Boolean.class || cls == Double.TYPE || cls == Double.class || cls == Float.TYPE || cls == Float.class || cls == Short.TYPE || cls == Short.class || cls == Integer.TYPE || cls == Integer.class || cls == Long.TYPE || cls == Long.class || cls == String.class || cls == Byte.TYPE || cls == Byte.class || cls == Character.TYPE || cls == Character.class;
    }

    public static boolean isPrimitive(Object cls) {
        return cls instanceof Boolean || cls instanceof Double || cls instanceof Float || cls instanceof Short || cls instanceof Integer || cls instanceof Long || cls instanceof String || cls instanceof Byte || cls instanceof Character;
    }

    public static Object defaultPrimitiveValue(Class<?> primitiveCls) {
        if (primitiveCls == Boolean.TYPE) {
            return false;
        }
        if (primitiveCls == Double.TYPE) {
            return 0.0;
        }
        if (primitiveCls == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (primitiveCls == Short.TYPE) {
            return (short)0;
        }
        if (primitiveCls == Integer.TYPE) {
            return 0;
        }
        if (primitiveCls == Long.TYPE) {
            return 0L;
        }
        if (primitiveCls == Byte.TYPE) {
            return (byte)0;
        }
        if (primitiveCls == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    public static Class<?> form(String typeName) {
        try {
            return Class.forName(typeName);
        }
        catch (Exception e) {
            return null;
        }
    }
}

