/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.mvc.multipart.MimeType;
import java.util.Random;

public final class StringKit {
    private static final Random random = new Random();

    private StringKit() {
    }

    public static int rand(int min, int max) {
        return random.nextInt(max) % (max - min + 1) + min;
    }

    public static String rand(int size) {
        String num = "";
        for (int i = 0; i < size; ++i) {
            double a = Math.random() * 9.0;
            a = Math.ceil(a);
            int randomNum = new Double(a).intValue();
            num = num + randomNum;
        }
        return num;
    }

    public static boolean isNotBlank(String str) {
        return null != str && !"".equals(str.trim());
    }

    public static boolean isBlank(String str) {
        return null == str || "".equals(str.trim());
    }

    public static boolean isNumber(String string) {
        try {
            double d = Double.parseDouble(string);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private static boolean notIsDigit(int c) {
        return !Character.isDigit(c);
    }

    public static String alignRight(Object o, int width, char c) {
        if (null == o) {
            return null;
        }
        String s = o.toString();
        int len = s.length();
        if (len >= width) {
            return s;
        }
        return StringKit.dup(c, width - len) + s;
    }

    public static String alignLeft(Object o, int width, char c) {
        if (null == o) {
            return null;
        }
        String s = o.toString();
        int length = s.length();
        if (length >= width) {
            return s;
        }
        return s + StringKit.dup(c, width - length);
    }

    public static String dup(char c, int num) {
        if (c == '\u0000' || num < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder(num);
        for (int i = 0; i < num; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    public static String fileExt(String fname) {
        if (StringKit.isBlank(fname) || fname.indexOf(46) == -1) {
            return null;
        }
        return fname.substring(fname.lastIndexOf(46) + 1);
    }

    public static String mimeType(String fname) {
        String ext = StringKit.fileExt(fname);
        if (null == ext) {
            return null;
        }
        return MimeType.get(ext);
    }

    public static boolean equals(String str1, String str2) {
        if (null == str1) {
            return false;
        }
        return str1.equals(str2);
    }
}

