/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.extract;

import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.extract.FilesToExtract;
import de.flapdoodle.embed.process.extract.IArchiveEntry;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.IExtractionMatch;
import de.flapdoodle.embed.process.extract.IExtractor;
import de.flapdoodle.embed.process.extract.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.io.progress.IProgressListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class ArchiveIsFileExtractor
implements IExtractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExtractedFileSet extract(IDownloadConfig runtime, File source, FilesToExtract toExtract) throws IOException {
        ImmutableExtractedFileSet.Builder builder = ImmutableExtractedFileSet.builder(toExtract.generatedBaseDir());
        IProgressListener progressListener = runtime.getProgressListener();
        String progressLabel = "Extract (not really) " + source;
        progressListener.start(progressLabel);
        IExtractionMatch match = toExtract.find(new FileAsArchiveEntry(source));
        if (match != null) {
            FileInputStream fin = new FileInputStream(source);
            try {
                BufferedInputStream in = new BufferedInputStream(fin);
                builder.file(match.type(), match.write(in, source.length()));
                if (!toExtract.nothingLeft()) {
                    progressListener.info(progressLabel, "Something went a little wrong. Listener say something is left, but we dont have anything");
                }
                progressListener.done(progressLabel);
            }
            finally {
                fin.close();
            }
        }
        return builder.build();
    }

    static class FileAsArchiveEntry
    implements IArchiveEntry {
        private final File _source;

        public FileAsArchiveEntry(File source) {
            this._source = source;
        }

        @Override
        public boolean isDirectory() {
            return this._source.isDirectory();
        }

        @Override
        public String getName() {
            return this._source.getName();
        }
    }
}

