/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.webservice;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JJavaName;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.ConsoleErrorReporter;
import com.sun.tools.xjc.api.ErrorListener;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import com.sun.tools.xjc.api.SchemaCompiler;
import com.sun.tools.xjc.api.XJC;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.xml.namespace.QName;
import org.activiti.bpmn.model.Import;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.data.PrimitiveStructureDefinition;
import org.activiti.engine.impl.bpmn.data.SimpleStructureDefinition;
import org.activiti.engine.impl.bpmn.data.StructureDefinition;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.XMLImporter;
import org.activiti.engine.impl.bpmn.webservice.BpmnInterfaceImplementation;
import org.activiti.engine.impl.bpmn.webservice.OperationImplementation;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.webservice.WSOperation;
import org.activiti.engine.impl.webservice.WSService;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.endpoint.dynamic.DynamicClientFactory;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.w3c.dom.Element;

public class CxfWSDLImporter
implements XMLImporter {
    protected static final String JAXB_BINDINGS_RESOURCE = "activiti-bindings.xjc";
    protected Map<String, WSService> wsServices = new HashMap<String, WSService>();
    protected Map<String, WSOperation> wsOperations = new HashMap<String, WSOperation>();
    protected Map<String, StructureDefinition> structures = new HashMap<String, StructureDefinition>();
    protected String wsdlLocation;
    protected String namespace = "";

    public void importFrom(Import theImport, BpmnParse parse) {
        this.namespace = theImport.getNamespace() == null ? "" : theImport.getNamespace() + ":";
        try {
            URIResolver uriResolver = new URIResolver(parse.getSourceSystemId(), theImport.getLocation());
            if (uriResolver.isResolved()) {
                if (uriResolver.getURI() != null) {
                    this.importFrom(uriResolver.getURI().toString());
                } else if (uriResolver.isFile()) {
                    this.importFrom(uriResolver.getFile().getAbsolutePath());
                } else if (uriResolver.getURL() != null) {
                    this.importFrom(uriResolver.getURL().toString());
                }
            } else {
                throw new UncheckedException((Throwable)new Exception("Unresolved import against " + parse.getSourceSystemId()));
            }
            this.transferImportsToParse(parse);
        }
        catch (IOException e) {
            throw new UncheckedException((Throwable)e);
        }
    }

    protected void transferImportsToParse(BpmnParse parse) {
        if (parse != null) {
            for (StructureDefinition structure : this.structures.values()) {
                parse.addStructure(structure);
            }
            for (WSService service : this.wsServices.values()) {
                parse.addService((BpmnInterfaceImplementation)service);
            }
            for (WSOperation operation : this.wsOperations.values()) {
                parse.addOperation((OperationImplementation)operation);
            }
        }
    }

    public void importFrom(String url) {
        block7: {
            this.wsServices.clear();
            this.wsOperations.clear();
            this.structures.clear();
            this.wsdlLocation = url;
            try {
                Bus bus = BusFactory.getDefaultBus();
                Enumeration<URL> xjcBindingUrls = Thread.currentThread().getContextClassLoader().getResources(JAXB_BINDINGS_RESOURCE);
                if (xjcBindingUrls.hasMoreElements()) {
                    URL xjcBindingUrl = xjcBindingUrls.nextElement();
                    if (xjcBindingUrls.hasMoreElements()) {
                        throw new ActivitiException("Several JAXB binding definitions found for activiti-cxf: activiti-bindings.xjc");
                    }
                    DynamicClientFactory.newInstance((Bus)bus).createClient(url, Arrays.asList(xjcBindingUrl.toString()));
                    WSDLManager wsdlManager = (WSDLManager)bus.getExtension(WSDLManager.class);
                    Definition def = wsdlManager.getDefinition(url);
                    WSDLServiceBuilder builder = new WSDLServiceBuilder(bus);
                    List services = builder.buildServices(def);
                    for (ServiceInfo service : services) {
                        WSService wsService = this.importService(service);
                        this.wsServices.put(this.namespace + wsService.getName(), wsService);
                    }
                    if (def != null && def.getTypes() != null) {
                        this.importTypes(def.getTypes());
                    }
                    break block7;
                }
                throw new ActivitiException("The JAXB binding definitions are not found for activiti-cxf: activiti-bindings.xjc");
            }
            catch (WSDLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                throw new ActivitiException("Error retrieveing the JAXB binding definitions", (Throwable)e);
            }
        }
    }

    protected WSService importService(ServiceInfo service) {
        String name = service.getName().getLocalPart();
        String location = "";
        for (EndpointInfo endpoint : service.getEndpoints()) {
            location = endpoint.getAddress();
        }
        WSService wsService = new WSService(this.namespace + name, location, this.wsdlLocation);
        for (OperationInfo operation : service.getInterface().getOperations()) {
            WSOperation wsOperation = this.importOperation(operation, wsService);
            wsService.addOperation(wsOperation);
            this.wsOperations.put(this.namespace + operation.getName().getLocalPart(), wsOperation);
        }
        return wsService;
    }

    protected WSOperation importOperation(OperationInfo operation, WSService service) {
        WSOperation wsOperation = new WSOperation(this.namespace + operation.getName().getLocalPart(), operation.getName().getLocalPart(), service);
        return wsOperation;
    }

    protected void importTypes(Types types) {
        SchemaCompiler compiler = XJC.createSchemaCompiler();
        ConsoleErrorReporter elForRun = new ConsoleErrorReporter();
        compiler.setErrorListener((ErrorListener)elForRun);
        SchemaImpl impl = (SchemaImpl)types.getExtensibilityElements().get(0);
        S2JJAXBModel intermediateModel = this.compileModel(types, compiler, impl.getElement());
        Collection mappings = intermediateModel.getMappings();
        for (Mapping mapping : mappings) {
            this.importStructure(mapping);
        }
    }

    protected void importStructure(Mapping mapping) {
        QName qname = mapping.getElement();
        JType type = mapping.getType().getTypeClass();
        if (type.isPrimitive()) {
            Class primitiveClass = ReflectUtil.loadClass((String)type.boxify().fullName());
            PrimitiveStructureDefinition structure = new PrimitiveStructureDefinition(this.namespace + qname.getLocalPart(), primitiveClass);
            this.structures.put(structure.getId(), (StructureDefinition)structure);
        } else if (type instanceof JDefinedClass) {
            JDefinedClass theClass = (JDefinedClass)type;
            SimpleStructureDefinition structure = new SimpleStructureDefinition(this.namespace + qname.getLocalPart());
            this.structures.put(structure.getId(), (StructureDefinition)structure);
            CxfWSDLImporter.importFields(theClass, structure);
        } else {
            Class referencedClass = ReflectUtil.loadClass((String)type.fullName());
            PrimitiveStructureDefinition structure = new PrimitiveStructureDefinition(this.namespace + qname.getLocalPart(), referencedClass);
            this.structures.put(structure.getId(), (StructureDefinition)structure);
        }
    }

    protected static void importFields(JDefinedClass theClass, SimpleStructureDefinition structure) {
        AtomicInteger index = new AtomicInteger(0);
        CxfWSDLImporter._importFields(theClass, index, structure);
    }

    protected static void _importFields(JDefinedClass theClass, AtomicInteger index, SimpleStructureDefinition structure) {
        JClass parentClass = theClass._extends();
        if (parentClass != null && parentClass instanceof JDefinedClass) {
            CxfWSDLImporter._importFields((JDefinedClass)parentClass, index, structure);
        }
        for (Map.Entry entry : theClass.fields().entrySet()) {
            Class fieldClass = ReflectUtil.loadClass((String)((JFieldVar)entry.getValue()).type().boxify().erasure().fullName());
            String fieldName = (String)entry.getKey();
            if (fieldName.startsWith("_") && !JJavaName.isJavaIdentifier((String)fieldName.substring(1))) {
                fieldName = fieldName.substring(1);
            }
            structure.setFieldName(index.getAndIncrement(), fieldName, fieldClass);
        }
    }

    protected S2JJAXBModel compileModel(Types types, SchemaCompiler compiler, Element rootTypes) {
        Schema schema = (Schema)types.getExtensibilityElements().get(0);
        compiler.parseSchema(schema.getDocumentBaseURI() + "#types1", rootTypes);
        S2JJAXBModel intermediateModel = compiler.bind();
        return intermediateModel;
    }

    public Collection<StructureDefinition> getStructures() {
        return this.structures.values();
    }

    public Collection<WSService> getServices() {
        return this.wsServices.values();
    }

    public Collection<WSOperation> getOperations() {
        return this.wsOperations.values();
    }
}

