/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.dml;

import org.apache.ignite.internal.processors.query.h2.dml.FastUpdateArguments;
import org.apache.ignite.internal.processors.query.h2.dml.KeyValueSupplier;
import org.apache.ignite.internal.processors.query.h2.dml.UpdateMode;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.typedef.F;

public final class UpdatePlan {
    public final UpdateMode mode;
    public final GridH2Table tbl;
    public final String[] colNames;
    public final int[] colTypes;
    public final KeyValueSupplier keySupplier;
    public final KeyValueSupplier valSupplier;
    public final int keyColIdx;
    public final int valColIdx;
    public final String selectQry;
    public final boolean isLocSubqry;
    public final int rowsNum;
    public final FastUpdateArguments fastUpdateArgs;

    private UpdatePlan(UpdateMode mode, GridH2Table tbl, String[] colNames, int[] colTypes, KeyValueSupplier keySupplier, KeyValueSupplier valSupplier, int keyColIdx, int valColIdx, String selectQry, boolean isLocSubqry, int rowsNum, FastUpdateArguments fastUpdateArgs) {
        this.colNames = colNames;
        this.colTypes = colTypes;
        this.rowsNum = rowsNum;
        assert (mode != null);
        assert (tbl != null);
        this.mode = mode;
        this.tbl = tbl;
        this.keySupplier = keySupplier;
        this.valSupplier = valSupplier;
        this.keyColIdx = keyColIdx;
        this.valColIdx = valColIdx;
        this.selectQry = selectQry;
        this.isLocSubqry = isLocSubqry;
        this.fastUpdateArgs = fastUpdateArgs;
    }

    public static UpdatePlan forMerge(GridH2Table tbl, String[] colNames, int[] colTypes, KeyValueSupplier keySupplier, KeyValueSupplier valSupplier, int keyColIdx, int valColIdx, String selectQry, boolean isLocSubqry, int rowsNum) {
        assert (!F.isEmpty((Object[])colNames));
        return new UpdatePlan(UpdateMode.MERGE, tbl, colNames, colTypes, keySupplier, valSupplier, keyColIdx, valColIdx, selectQry, isLocSubqry, rowsNum, null);
    }

    public static UpdatePlan forInsert(GridH2Table tbl, String[] colNames, int[] colTypes, KeyValueSupplier keySupplier, KeyValueSupplier valSupplier, int keyColIdx, int valColIdx, String selectQry, boolean isLocSubqry, int rowsNum) {
        assert (!F.isEmpty((Object[])colNames));
        return new UpdatePlan(UpdateMode.INSERT, tbl, colNames, colTypes, keySupplier, valSupplier, keyColIdx, valColIdx, selectQry, isLocSubqry, rowsNum, null);
    }

    public static UpdatePlan forUpdate(GridH2Table tbl, String[] colNames, int[] colTypes, KeyValueSupplier valSupplier, int valColIdx, String selectQry) {
        assert (!F.isEmpty((Object[])colNames));
        return new UpdatePlan(UpdateMode.UPDATE, tbl, colNames, colTypes, null, valSupplier, -1, valColIdx, selectQry, false, 0, null);
    }

    public static UpdatePlan forDelete(GridH2Table tbl, String selectQry) {
        return new UpdatePlan(UpdateMode.DELETE, tbl, null, null, null, null, -1, -1, selectQry, false, 0, null);
    }

    public static UpdatePlan forFastUpdate(UpdateMode mode, GridH2Table tbl, FastUpdateArguments fastUpdateArgs) {
        assert (mode == UpdateMode.UPDATE || mode == UpdateMode.DELETE);
        return new UpdatePlan(mode, tbl, null, null, null, null, -1, -1, null, false, 0, fastUpdateArgs);
    }
}

