/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.ArrayList;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class GridSqlJoin
extends GridSqlElement {
    private boolean leftOuter;

    public GridSqlJoin(GridSqlElement leftTbl, GridSqlElement rightTbl, boolean leftOuter, @Nullable GridSqlElement on) {
        super(new ArrayList<GridSqlElement>(3));
        this.addChild(leftTbl);
        this.addChild(rightTbl);
        if (on == null) {
            on = GridSqlConst.TRUE;
        }
        this.addChild(on);
        this.leftOuter = leftOuter;
    }

    public GridSqlElement leftTable() {
        return this.child(0);
    }

    public GridSqlElement rightTable() {
        return this.child(1);
    }

    public GridSqlElement on() {
        return this.child(2);
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder();
        buff.append(this.leftTable().getSQL());
        buff.append(this.leftOuter ? " \n LEFT OUTER JOIN " : " \n INNER JOIN ");
        buff.append(this.rightTable().getSQL());
        buff.append(" \n ON ").append(StringUtils.unEnclose((String)this.on().getSQL()));
        return buff.toString();
    }
}

