/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.resolvers.AbstractResolveMojo;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.codehaus.plexus.util.IOUtil;

@Mojo(name="resolve-plugins", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ResolvePluginsMojo
extends AbstractResolveMojo {
    @Parameter(defaultValue="${project.pluginArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remotePluginRepositories;
    @Parameter(property="excludeTransitive", defaultValue="false")
    private boolean excludeTransitive;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doExecute() throws MojoExecutionException {
        Writer outputWriter = null;
        try {
            Set<Artifact> plugins = this.resolvePluginArtifacts();
            if (this.outputFile != null) {
                this.outputFile.getParentFile().mkdirs();
                outputWriter = new FileWriter(this.outputFile);
            }
            for (Artifact plugin : plugins) {
                String logStr = "Plugin Resolved: " + DependencyUtil.getFormattedFileName(plugin, false);
                if (!this.isSilent()) {
                    this.getLog().info((CharSequence)logStr);
                }
                if (outputWriter != null) {
                    outputWriter.write(logStr);
                    outputWriter.write("\n");
                }
                if (this.excludeTransitive) continue;
                DefaultDependableCoordinate pluginCoordinate = new DefaultDependableCoordinate();
                pluginCoordinate.setGroupId(plugin.getGroupId());
                pluginCoordinate.setArtifactId(plugin.getArtifactId());
                pluginCoordinate.setVersion(plugin.getVersion());
                for (Artifact artifact : this.resolveArtifactDependencies((DependableCoordinate)pluginCoordinate)) {
                    logStr = "    Plugin Dependency Resolved: " + DependencyUtil.getFormattedFileName(artifact, false);
                    if (!this.isSilent()) {
                        this.getLog().info((CharSequence)logStr);
                    }
                    if (outputWriter == null) continue;
                    outputWriter.write(logStr);
                    outputWriter.write("\n");
                }
            }
            if (outputWriter != null) {
                outputWriter.close();
                outputWriter = null;
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Nested:", (Exception)e);
                catch (ArtifactFilterException e2) {
                    throw new MojoExecutionException("Nested:", (Exception)((Object)e2));
                }
                catch (ArtifactResolverException e3) {
                    throw new MojoExecutionException("Nested:", (Exception)((Object)e3));
                }
                catch (DependencyResolverException e4) {
                    throw new MojoExecutionException("Nested:", (Exception)((Object)e4));
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(outputWriter);
                throw throwable;
            }
        }
        IOUtil.close((Writer)outputWriter);
    }

    protected Set<Artifact> resolvePluginArtifacts() throws ArtifactFilterException, ArtifactResolverException {
        Set plugins = this.getProject().getPluginArtifacts();
        Set reports = this.getProject().getReportArtifacts();
        Set<Artifact> artifacts = new HashSet();
        artifacts.addAll(reports);
        artifacts.addAll(plugins);
        FilterArtifacts filter = this.getPluginArtifactsFilter();
        artifacts = filter.filter(artifacts);
        HashSet<Artifact> resolvedArtifacts = new HashSet<Artifact>(artifacts.size());
        for (Artifact artifact : new HashSet(artifacts)) {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            buildingRequest.setRemoteRepositories(this.remotePluginRepositories);
            resolvedArtifacts.add(this.getArtifactResolver().resolveArtifact((ProjectBuildingRequest)buildingRequest, artifact).getArtifact());
        }
        return artifacts;
    }

    @Override
    protected ArtifactsFilter getMarkedArtifactFilter() {
        return null;
    }
}

