/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.client;

import io.netty.channel.Channel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final long CHANNEL_EXPIRED_TIMEOUT = 120000L;
    private final ConcurrentHashMap<String, ConsumerGroupInfo> consumerTable = new ConcurrentHashMap(1024);
    private final ConsumerIdsChangeListener consumerIdsChangeListener;

    public ConsumerManager(ConsumerIdsChangeListener consumerIdsChangeListener) {
        this.consumerIdsChangeListener = consumerIdsChangeListener;
    }

    public ClientChannelInfo findChannel(String group, String clientId) {
        ConsumerGroupInfo consumerGroupInfo = this.consumerTable.get(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.findChannel(clientId);
        }
        return null;
    }

    public SubscriptionData findSubscriptionData(String group, String topic) {
        ConsumerGroupInfo consumerGroupInfo = this.getConsumerGroupInfo(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.findSubscriptionData(topic);
        }
        return null;
    }

    public ConsumerGroupInfo getConsumerGroupInfo(String group) {
        return this.consumerTable.get(group);
    }

    public int findSubscriptionDataCount(String group) {
        ConsumerGroupInfo consumerGroupInfo = this.getConsumerGroupInfo(group);
        if (consumerGroupInfo != null) {
            return consumerGroupInfo.getSubscriptionTable().size();
        }
        return 0;
    }

    public void doChannelCloseEvent(String remoteAddr, Channel channel) {
        for (Map.Entry<String, ConsumerGroupInfo> next : this.consumerTable.entrySet()) {
            ConsumerGroupInfo remove;
            ConsumerGroupInfo info = next.getValue();
            boolean removed = info.doChannelCloseEvent(remoteAddr, channel);
            if (!removed) continue;
            if (info.getChannelInfoTable().isEmpty() && (remove = this.consumerTable.remove(next.getKey())) != null) {
                log.info("unregister consumer ok, no any connection, and remove consumer group, {}", (Object)next.getKey());
            }
            this.consumerIdsChangeListener.consumerIdsChanged(next.getKey(), info.getAllChannel());
        }
    }

    public boolean registerConsumer(String group, ClientChannelInfo clientChannelInfo, ConsumeType consumeType, MessageModel messageModel, ConsumeFromWhere consumeFromWhere, Set<SubscriptionData> subList, boolean isNotifyConsumerIdsChangedEnable) {
        ConsumerGroupInfo consumerGroupInfo = this.consumerTable.get(group);
        if (null == consumerGroupInfo) {
            ConsumerGroupInfo tmp = new ConsumerGroupInfo(group, consumeType, messageModel, consumeFromWhere);
            ConsumerGroupInfo prev = this.consumerTable.putIfAbsent(group, tmp);
            consumerGroupInfo = prev != null ? prev : tmp;
        }
        boolean r1 = consumerGroupInfo.updateChannel(clientChannelInfo, consumeType, messageModel, consumeFromWhere);
        boolean r2 = consumerGroupInfo.updateSubscription(subList);
        if ((r1 || r2) && isNotifyConsumerIdsChangedEnable) {
            this.consumerIdsChangeListener.consumerIdsChanged(group, consumerGroupInfo.getAllChannel());
        }
        return r1 || r2;
    }

    public void unregisterConsumer(String group, ClientChannelInfo clientChannelInfo, boolean isNotifyConsumerIdsChangedEnable) {
        ConsumerGroupInfo consumerGroupInfo = this.consumerTable.get(group);
        if (null != consumerGroupInfo) {
            ConsumerGroupInfo remove;
            consumerGroupInfo.unregisterChannel(clientChannelInfo);
            if (consumerGroupInfo.getChannelInfoTable().isEmpty() && (remove = this.consumerTable.remove(group)) != null) {
                log.info("unregister consumer ok, no any connection, and remove consumer group, {}", (Object)group);
            }
            if (isNotifyConsumerIdsChangedEnable) {
                this.consumerIdsChangeListener.consumerIdsChanged(group, consumerGroupInfo.getAllChannel());
            }
        }
    }

    public void scanNotActiveChannel() {
        Iterator<Map.Entry<String, ConsumerGroupInfo>> it = this.consumerTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ConsumerGroupInfo> next = it.next();
            String group = next.getKey();
            ConsumerGroupInfo consumerGroupInfo = next.getValue();
            ConcurrentHashMap<Channel, ClientChannelInfo> channelInfoTable = consumerGroupInfo.getChannelInfoTable();
            Iterator<Map.Entry<Channel, ClientChannelInfo>> itChannel = channelInfoTable.entrySet().iterator();
            while (itChannel.hasNext()) {
                Map.Entry<Channel, ClientChannelInfo> nextChannel = itChannel.next();
                ClientChannelInfo clientChannelInfo = nextChannel.getValue();
                long diff = System.currentTimeMillis() - clientChannelInfo.getLastUpdateTimestamp();
                if (diff <= 120000L) continue;
                log.warn("SCAN: remove expired channel from ConsumerManager consumerTable. channel={}, consumerGroup={}", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)clientChannelInfo.getChannel()), (Object)group);
                RemotingUtil.closeChannel((Channel)clientChannelInfo.getChannel());
                itChannel.remove();
            }
            if (!channelInfoTable.isEmpty()) continue;
            log.warn("SCAN: remove expired channel from ConsumerManager consumerTable, all clear, consumerGroup={}", (Object)group);
            it.remove();
        }
    }

    public HashSet<String> queryTopicConsumeByWho(String topic) {
        HashSet<String> groups = new HashSet<String>();
        for (Map.Entry<String, ConsumerGroupInfo> entry : this.consumerTable.entrySet()) {
            ConcurrentHashMap<String, SubscriptionData> subscriptionTable = entry.getValue().getSubscriptionTable();
            if (!subscriptionTable.containsKey(topic)) continue;
            groups.add(entry.getKey());
        }
        return groups;
    }
}

