/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.mgt;

import java.io.Serializable;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSubjectFactory;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.ShiroHttpServletRequest;
import org.apache.shiro.web.session.mgt.DefaultWebSessionContext;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.apache.shiro.web.session.mgt.ServletContainerSessionManager;
import org.apache.shiro.web.session.mgt.WebSessionKey;
import org.apache.shiro.web.subject.WebSubject;
import org.apache.shiro.web.subject.WebSubjectContext;
import org.apache.shiro.web.subject.support.DefaultWebSubjectContext;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebSecurityManager
extends DefaultSecurityManager
implements WebSecurityManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWebSecurityManager.class);
    public static final String HTTP_SESSION_MODE = "http";
    public static final String NATIVE_SESSION_MODE = "native";
    private String sessionMode = "http";

    public DefaultWebSecurityManager() {
        this.setSubjectFactory(new DefaultWebSubjectFactory());
        this.setRememberMeManager(new CookieRememberMeManager());
        this.setSessionManager(new ServletContainerSessionManager());
    }

    public DefaultWebSecurityManager(Realm singleRealm) {
        this();
        this.setRealm(singleRealm);
    }

    public DefaultWebSecurityManager(Collection<Realm> realms) {
        this();
        this.setRealms(realms);
    }

    @Override
    protected SubjectContext createSubjectContext() {
        return new DefaultWebSubjectContext();
    }

    @Override
    protected SubjectContext copy(SubjectContext subjectContext) {
        if (subjectContext instanceof WebSubjectContext) {
            return new DefaultWebSubjectContext((WebSubjectContext)subjectContext);
        }
        return super.copy(subjectContext);
    }

    public String getSessionMode() {
        return this.sessionMode;
    }

    public void setSessionMode(String sessionMode) {
        String mode = sessionMode;
        if (mode == null) {
            throw new IllegalArgumentException("sessionMode argument cannot be null.");
        }
        mode = sessionMode.toLowerCase();
        if (!HTTP_SESSION_MODE.equals(mode) && !NATIVE_SESSION_MODE.equals(mode)) {
            String msg = "Invalid sessionMode [" + sessionMode + "].  Allowed values are " + "public static final String constants in the " + this.getClass().getName() + " class: '" + HTTP_SESSION_MODE + "' or '" + NATIVE_SESSION_MODE + "', with '" + HTTP_SESSION_MODE + "' being the default.";
            throw new IllegalArgumentException(msg);
        }
        boolean recreate = this.sessionMode == null || !this.sessionMode.equals(mode);
        this.sessionMode = mode;
        if (recreate) {
            LifecycleUtils.destroy(this.getSessionManager());
            SessionManager sessionManager = this.createSessionManager(mode);
            this.setSessionManager(sessionManager);
        }
    }

    @Override
    public boolean isHttpSessionMode() {
        return this.sessionMode == null || this.sessionMode.equals(HTTP_SESSION_MODE);
    }

    protected SessionManager createSessionManager(String sessionMode) {
        if (sessionMode == null || sessionMode.equalsIgnoreCase(HTTP_SESSION_MODE)) {
            if (log.isInfoEnabled()) {
                log.info("http mode - enabling ServletContainerSessionManager (HTTP-only Sessions)");
            }
            return new ServletContainerSessionManager();
        }
        if (log.isInfoEnabled()) {
            log.info("native mode - enabling DefaultWebSessionManager (HTTP + heterogeneous-client sessions)");
        }
        return new DefaultWebSessionManager();
    }

    @Override
    protected SessionContext createSessionContext(SubjectContext subjectContext) {
        SessionContext sessionContext = super.createSessionContext(subjectContext);
        if (subjectContext instanceof WebSubjectContext) {
            WebSubjectContext wsc = (WebSubjectContext)subjectContext;
            ServletRequest request = wsc.resolveServletRequest();
            ServletResponse response = wsc.resolveServletResponse();
            DefaultWebSessionContext webSessionContext = new DefaultWebSessionContext(sessionContext);
            if (request != null) {
                webSessionContext.setServletRequest(request);
            }
            if (response != null) {
                webSessionContext.setServletResponse(response);
            }
            sessionContext = webSessionContext;
        }
        return sessionContext;
    }

    @Override
    protected SessionKey getSessionKey(SubjectContext context) {
        if (WebUtils.isWeb(context)) {
            Serializable sessionId = context.getSessionId();
            ServletRequest request = WebUtils.getRequest(context);
            ServletResponse response = WebUtils.getResponse(context);
            return new WebSessionKey(sessionId, request, response);
        }
        return super.getSessionKey(context);
    }

    @Override
    protected void beforeLogout(Subject subject) {
        super.beforeLogout(subject);
        this.removeRequestIdentity(subject);
    }

    protected void removeRequestIdentity(Subject subject) {
        WebSubject webSubject;
        ServletRequest request;
        if (subject instanceof WebSubject && (request = (webSubject = (WebSubject)subject).getServletRequest()) != null) {
            request.setAttribute(ShiroHttpServletRequest.IDENTITY_REMOVED_KEY, (Object)Boolean.TRUE);
        }
    }
}

