/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import java.util.Map;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniFactorySupport;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.web.config.IniFilterChainResolverFactory;
import org.apache.shiro.web.config.WebIniSecurityManagerFactory;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniShiroFilter
extends AbstractShiroFilter {
    public static final String CONFIG_INIT_PARAM_NAME = "config";
    public static final String CONFIG_PATH_INIT_PARAM_NAME = "configPath";
    private static final Logger log = LoggerFactory.getLogger(IniShiroFilter.class);
    private String config;
    private String configPath;

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    @Override
    public void init() throws Exception {
        this.applyInitParams();
        this.configure();
    }

    protected void applyInitParams() throws Exception {
        String configPath;
        String config = this.getInitParam(CONFIG_INIT_PARAM_NAME);
        if (config != null) {
            this.setConfig(config);
        }
        if ((configPath = this.getInitParam(CONFIG_PATH_INIT_PARAM_NAME)) != null) {
            this.setConfigPath(configPath);
        }
    }

    protected void configure() throws Exception {
        Ini ini = this.loadIniFromConfig();
        if (CollectionUtils.isEmpty(ini)) {
            log.info("Null or empty configuration specified via 'config' init-param.  Checking path-based configuration.");
            ini = this.loadIniFromPath();
        }
        if (CollectionUtils.isEmpty(ini)) {
            log.info("Null or empty configuration specified via 'config' or 'configPath' filter parameters.  Trying the default classpath:shiro.ini file.");
            ini = IniFactorySupport.loadDefaultClassPathIni();
        }
        Map<String, ?> objects = this.applySecurityManager(ini);
        this.applyFilterChainResolver(ini, objects);
    }

    protected Ini loadIniFromConfig() {
        Ini ini = null;
        String config = this.getConfig();
        if (config != null) {
            ini = this.convertConfigToIni(config);
        }
        return ini;
    }

    protected Ini loadIniFromPath() {
        Ini ini = null;
        String path = this.getConfigPath();
        if (path != null) {
            ini = this.convertPathToIni(path);
        }
        return ini;
    }

    protected Map<String, ?> applySecurityManager(Ini ini) {
        WebIniSecurityManagerFactory factory = CollectionUtils.isEmpty(ini) ? new WebIniSecurityManagerFactory() : new WebIniSecurityManagerFactory(ini);
        SecurityManager securityManager = (SecurityManager)factory.getInstance();
        if (!(securityManager instanceof WebSecurityManager)) {
            String msg = "The configured security manager is not an instance of WebSecurityManager, so it can not be used with the Shiro servlet filter.";
            throw new ConfigurationException(msg);
        }
        this.setSecurityManager((WebSecurityManager)securityManager);
        return factory.getBeans();
    }

    protected void applyFilterChainResolver(Ini ini, Map<String, ?> defaults) {
        if (ini == null || ini.isEmpty()) {
            return;
        }
        Ini.Section urls = ini.getSection("urls");
        Ini.Section filters = ini.getSection("filters");
        if (urls != null && !urls.isEmpty() || filters != null && !filters.isEmpty()) {
            IniFilterChainResolverFactory filterChainResolverFactory = new IniFilterChainResolverFactory(ini, defaults);
            filterChainResolverFactory.setFilterConfig(this.getFilterConfig());
            FilterChainResolver resolver = (FilterChainResolver)filterChainResolverFactory.getInstance();
            this.setFilterChainResolver(resolver);
        }
    }

    protected Ini convertConfigToIni(String config) {
        Ini ini = new Ini();
        ini.load(config);
        return ini;
    }

    protected Ini convertPathToIni(String path) {
        Ini ini = new Ini();
        ini.loadFromPath(path);
        return ini;
    }
}

