/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONCollection;
import org.apache.tapestry5.json.JSONLiteral;
import org.apache.tapestry5.json.JSONPrintSession;
import org.apache.tapestry5.json.JSONString;
import org.apache.tapestry5.json.JSONTokener;

public final class JSONObject
extends JSONCollection {
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    public static final Object NULL = new Null();
    private static final Class[] ALLOWED = new Class[]{String.class, Boolean.class, Number.class, JSONObject.class, JSONArray.class, JSONString.class, JSONLiteral.class, Null.class};

    public JSONObject() {
    }

    public JSONObject copy() {
        JSONObject dupe = new JSONObject();
        dupe.properties.putAll(this.properties);
        return dupe;
    }

    public JSONObject(Object ... keysAndValues) {
        int i = 0;
        while (i < keysAndValues.length) {
            this.put(keysAndValues[i++].toString(), keysAndValues[i++]);
        }
    }

    public JSONObject(JSONObject source, String ... propertyNames) {
        for (String name : propertyNames) {
            Object value = source.opt(name);
            if (value == null) continue;
            this.put(name, value);
        }
    }

    JSONObject(JSONTokener x) {
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c == '=') {
                if (x.next() != '>') {
                    x.back();
                }
            } else if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.put(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }

    public JSONObject(String string) {
        this(new JSONTokener(string));
    }

    public JSONObject accumulate(String key, Object value) {
        JSONObject.testValidity(value);
        Object existing = this.opt(key);
        if (existing == null) {
            this.put(key, value);
            return this;
        }
        if (existing instanceof JSONArray) {
            ((JSONArray)existing).put(value);
            return this;
        }
        this.put(key, new JSONArray().put(existing).put(value));
        return this;
    }

    public JSONObject append(String key, Object value) {
        JSONObject.testValidity(value);
        Object o = this.opt(key);
        if (o == null) {
            this.put(key, new JSONArray().put(value));
        } else if (o instanceof JSONArray) {
            this.put(key, ((JSONArray)o).put(value));
        } else {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONArray.");
        }
        return this;
    }

    static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String s = Double.toString(d);
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object get(String key) {
        Object o = this.opt(key);
        if (o == null) {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] not found.");
        }
        return o;
    }

    public boolean getBoolean(String key) {
        Object o = this.get(key);
        if (o instanceof Boolean) {
            return o.equals(Boolean.TRUE);
        }
        if (o instanceof String) {
            String value = (String)o;
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
        }
        throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) {
        Object value = this.get(key);
        try {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.valueOf((String)value);
        }
        catch (Exception e) {
            throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not a number.");
        }
    }

    public int getInt(String key) {
        Object value = this.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return (int)this.getDouble(key);
    }

    public JSONArray getJSONArray(String key) {
        Object o = this.get(key);
        if (o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) {
        Object o = this.get(key);
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new RuntimeException("JSONObject[" + JSONObject.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) {
        Object o = this.get(key);
        return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
    }

    public String getString(String key) {
        return this.get(key).toString();
    }

    public boolean has(String key) {
        return this.properties.containsKey(key);
    }

    public boolean isNull(String key) {
        return NULL.equals(this.opt(key));
    }

    public Set<String> keys() {
        return this.properties.keySet();
    }

    public int length() {
        return this.properties.size();
    }

    public JSONArray names() {
        JSONArray ja = new JSONArray();
        for (String key : this.keys()) {
            ja.put(key);
        }
        return ja.length() == 0 ? null : ja;
    }

    static String numberToString(Number n) {
        assert (n != null);
        JSONObject.testValidity(n);
        String s = n.toString();
        if (s.indexOf(46) > 0 && s.indexOf(101) < 0 && s.indexOf(69) < 0) {
            while (s.endsWith("0")) {
                s = s.substring(0, s.length() - 1);
            }
            if (s.endsWith(".")) {
                s = s.substring(0, s.length() - 1);
            }
        }
        return s;
    }

    public Object opt(String key) {
        return this.properties.get(key);
    }

    public JSONObject put(String key, Object value) {
        assert (key != null);
        if (value != null) {
            JSONObject.testValidity(value);
            this.properties.put(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder buffer = new StringBuilder(len + 4);
        buffer.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        buffer.append('\\');
                    }
                    buffer.append(c);
                    continue block9;
                }
                case '\b': {
                    buffer.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buffer.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        buffer.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    buffer.append(c);
                }
            }
        }
        buffer.append('\"');
        return buffer.toString();
    }

    public Object remove(String key) {
        return this.properties.remove(key);
    }

    static void testValidity(Object value) {
        Float asFloat;
        if (value == null) {
            throw new IllegalArgumentException("null isn't valid in JSONObject and JSONArray. Use JSONObject.NULL instead.");
        }
        boolean found = false;
        Class<?> actual = value.getClass();
        for (Class allowed : ALLOWED) {
            if (!allowed.isAssignableFrom(actual)) continue;
            found = true;
            break;
        }
        if (!found) {
            ArrayList<String> typeNames = new ArrayList<String>();
            for (Class c : ALLOWED) {
                String name = c.getName();
                if (name.startsWith("java.lang.")) {
                    name = name.substring(10);
                }
                typeNames.add(name);
            }
            Collections.sort(typeNames);
            StringBuilder joined = new StringBuilder();
            String sep = "";
            for (String name : typeNames) {
                joined.append(sep);
                joined.append(name);
                sep = ", ";
            }
            String message = String.format("JSONObject properties may be one of %s. Type %s is not allowed.", joined.toString(), actual.getName());
            throw new RuntimeException(message);
        }
        if (value instanceof Double) {
            Double asDouble = (Double)value;
            if (asDouble.isInfinite() || asDouble.isNaN()) {
                throw new RuntimeException("JSON does not allow non-finite numbers.");
            }
            return;
        }
        if (value instanceof Float && ((asFloat = (Float)value).isInfinite() || asFloat.isNaN())) {
            throw new RuntimeException("JSON does not allow non-finite numbers.");
        }
    }

    @Override
    void print(JSONPrintSession session) {
        session.printSymbol('{');
        session.indent();
        boolean comma = false;
        for (String key : this.keys()) {
            if (comma) {
                session.printSymbol(',');
            }
            session.newline();
            session.printQuoted(key);
            session.printSymbol(':');
            JSONObject.printValue(session, this.properties.get(key));
            comma = true;
        }
        session.outdent();
        if (comma) {
            session.newline();
        }
        session.printSymbol('}');
    }

    static void printValue(JSONPrintSession session, Object value) {
        if (value instanceof JSONObject) {
            ((JSONObject)value).print(session);
            return;
        }
        if (value instanceof JSONArray) {
            ((JSONArray)value).print(session);
            return;
        }
        if (value instanceof JSONString) {
            String printValue = ((JSONString)value).toJSONString();
            session.print(printValue);
            return;
        }
        if (value instanceof Number) {
            String printValue = JSONObject.numberToString((Number)value);
            session.print(printValue);
            return;
        }
        if (value instanceof Boolean) {
            session.print(value.toString());
            return;
        }
        session.printQuoted(value.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONObject)) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        return this.properties.equals(other.properties);
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.properties);
    }

    public JSONObject putAll(Map<String, ?> newProperties) {
        assert (newProperties != null);
        for (Map.Entry<String, ?> e : newProperties.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
        return this;
    }

    public JSONObject in(String key) {
        assert (key != null);
        Object nested = this.properties.get(key);
        if (nested != null && !(nested instanceof JSONObject)) {
            throw new IllegalStateException(String.format("JSONObject[%s] is not a JSONObject.", JSONObject.quote(key)));
        }
        if (nested == null) {
            nested = new JSONObject();
            this.properties.put(key, nested);
        }
        return (JSONObject)nested;
    }

    private static final class Null
    implements JSONString,
    Serializable {
        private Null() {
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public String toString() {
            return "null";
        }

        @Override
        public String toJSONString() {
            return "null";
        }

        private Object readResolve() throws ObjectStreamException {
            return NULL;
        }
    }
}

