/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.net.URI;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GatewayServicesManagementCheckAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayServicesManagementCheckAction.class);
    private final ServicesManager servicesManager;

    protected Event doExecute(RequestContext context) {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
        if (registeredService == null) {
            String msg = String.format("Unauthorized Service Access: Service [%s] does not match entries in service registry.", service.getId());
            LOGGER.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("Access to service [%s] is disabled by the service registry.", service.getId());
            LOGGER.warn(msg);
            WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)registeredService.getAccessStrategy().getUnauthorizedRedirectUrl());
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        return this.success();
    }

    @Generated
    public GatewayServicesManagementCheckAction(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }
}

