/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.net.URI;
import lombok.Generated;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class GenerateServiceTicketAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateServiceTicketAction.class);
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final CentralAuthenticationService centralAuthenticationService;
    private final TicketRegistrySupport ticketRegistrySupport;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    private final ServicesManager servicesManager;
    private final PrincipalElectionStrategy principalElectionStrategy;

    protected Event doExecute(RequestContext context) {
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        LOGGER.trace("Service asking for service ticket is [{}]", (Object)service);
        String ticketGrantingTicket = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        LOGGER.debug("Ticket-granting ticket found in the context is [{}]", (Object)ticketGrantingTicket);
        try {
            Authentication authentication = this.ticketRegistrySupport.getAuthenticationFrom(ticketGrantingTicket);
            if (authentication == null) {
                AuthenticationException authn = new AuthenticationException("No authentication found for ticket " + ticketGrantingTicket);
                throw new InvalidTicketException((Throwable)authn, ticketGrantingTicket);
            }
            Service selectedService = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)service);
            RegisteredService registeredService = this.servicesManager.findServiceBy(selectedService);
            LOGGER.debug("Registered service asking for service ticket is [{}]", (Object)registeredService);
            WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)registeredService);
            WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
            if (registeredService != null) {
                URI url = registeredService.getAccessStrategy().getUnauthorizedRedirectUrl();
                if (url != null) {
                    LOGGER.debug("Registered service may redirect to [{}] for unauthorized access requests", (Object)url);
                }
                WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)url);
            }
            if (WebUtils.getWarningCookie((RequestContext)context)) {
                LOGGER.debug("Warning cookie is present in the request context. Routing result to [{}] state", (Object)"warn");
                return this.result("warn");
            }
            Credential credential = WebUtils.getCredential((RequestContext)context);
            AuthenticationResultBuilder builder = this.authenticationSystemSupport.establishAuthenticationContextFromInitial(authentication, credential);
            AuthenticationResult authenticationResult = builder.build(this.principalElectionStrategy, (Service)service);
            LOGGER.trace("Built the final authentication result [{}] to grant service ticket to [{}]", (Object)authenticationResult, (Object)service);
            ServiceTicket serviceTicketId = this.centralAuthenticationService.grantServiceTicket(ticketGrantingTicket, (Service)service, authenticationResult);
            WebUtils.putServiceTicketInRequestScope((RequestContext)context, (ServiceTicket)serviceTicketId);
            LOGGER.debug("Granted service ticket [{}] and added it to the request scope", (Object)serviceTicketId);
            return this.success();
        }
        catch (AbstractTicketException e) {
            if (e instanceof InvalidTicketException) {
                LOGGER.debug("CAS has determined ticket-granting ticket [{}] is invalid and must be destroyed", (Object)ticketGrantingTicket);
                this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicket);
            }
            if (this.isGatewayPresent(context)) {
                LOGGER.debug("Request indicates that it is gateway. Routing result to [{}] state", (Object)"gateway");
                return this.result("gateway");
            }
            LOGGER.warn("Could not grant service ticket [{}]. Routing to [{}]", (Object)e.getMessage(), (Object)"authenticationFailure");
            return this.newEvent("authenticationFailure", (Exception)((Object)e));
        }
    }

    protected boolean isGatewayPresent(RequestContext context) {
        ParameterMap requestParameterMap = context.getExternalContext().getRequestParameterMap();
        return StringUtils.hasText((String)requestParameterMap.get("gateway"));
    }

    private Event newEvent(String id, Exception error) {
        return new EventFactorySupport().event((Object)this, id, (AttributeMap)new LocalAttributeMap("error", (Object)error));
    }

    @Generated
    public GenerateServiceTicketAction(AuthenticationSystemSupport authenticationSystemSupport, CentralAuthenticationService centralAuthenticationService, TicketRegistrySupport ticketRegistrySupport, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, ServicesManager servicesManager, PrincipalElectionStrategy principalElectionStrategy) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.servicesManager = servicesManager;
        this.principalElectionStrategy = principalElectionStrategy;
    }
}

