/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import java.net.URI;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ServiceAuthorizationCheckAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceAuthorizationCheckAction.class);
    private final ServicesManager servicesManager;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;

    protected Event doExecute(RequestContext context) {
        WebApplicationService serviceInContext = WebUtils.getService((RequestContext)context);
        Service service = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)serviceInContext);
        if (service == null) {
            return this.success();
        }
        if (this.servicesManager.getAllServices().isEmpty()) {
            String msg = String.format("No service definitions are found in the service manager. Service [%s] will not be automatically authorized to request authentication.", service.getId());
            LOGGER.warn(msg);
            throw new UnauthorizedServiceException("screen.service.empty.error.message", msg);
        }
        RegisteredService registeredService = this.servicesManager.findServiceBy(service);
        if (registeredService == null) {
            String msg = String.format("Service [%s] is not found in service registry.", service.getId());
            LOGGER.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("Service Management: Unauthorized Service Access. Service [%s] is not allowed access via the service registry.", service.getId());
            LOGGER.warn(msg);
            WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)registeredService.getAccessStrategy().getUnauthorizedRedirectUrl());
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        return this.success();
    }

    @Generated
    public ServiceAuthorizationCheckAction(ServicesManager servicesManager, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies) {
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
    }
}

