/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategy;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.repository.NoSuchFlowExecutionException;

public class InitialFlowSetupAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialFlowSetupAction.class);
    private final List<ArgumentExtractor> argumentExtractors;
    private final ServicesManager servicesManager;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    private final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    private final CookieRetrievingCookieGenerator warnCookieGenerator;
    private final CasConfigurationProperties casProperties;
    private final AuthenticationEventExecutionPlan authenticationEventExecutionPlan;

    public Event doExecute(RequestContext context) {
        this.configureCookieGenerators(context);
        this.configureWebflowContext(context);
        this.configureWebflowContextForService(context);
        return this.success();
    }

    private void configureWebflowContextForService(RequestContext context) {
        WebUtils.putCustomLoginFormFields((RequestContext)context, (Map)this.casProperties.getView().getCustomLoginFormFields());
        WebApplicationService service = WebUtils.getService(this.argumentExtractors, (RequestContext)context);
        if (service != null) {
            LOGGER.debug("Placing service in context scope: [{}]", (Object)service.getId());
            Service selectedService = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)service);
            RegisteredService registeredService = this.servicesManager.findServiceBy(selectedService);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
            if (registeredService != null && registeredService.getAccessStrategy().isServiceAccessAllowed()) {
                LOGGER.debug("Placing registered service [{}] with id [{}] in context scope", (Object)registeredService.getServiceId(), (Object)registeredService.getId());
                WebUtils.putRegisteredService((RequestContext)context, (RegisteredService)registeredService);
                RegisteredServiceAccessStrategy accessStrategy = registeredService.getAccessStrategy();
                if (accessStrategy.getUnauthorizedRedirectUrl() != null) {
                    LOGGER.debug("Placing registered service's unauthorized redirect url [{}] with id [{}] in context scope", (Object)accessStrategy.getUnauthorizedRedirectUrl(), (Object)registeredService.getServiceId());
                    WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)accessStrategy.getUnauthorizedRedirectUrl());
                }
            }
        } else if (!this.casProperties.getSso().isAllowMissingServiceParameter()) {
            LOGGER.warn("No service authentication request is available at [{}]. CAS is configured to disable the flow.", (Object)WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context).getRequestURL());
            throw new NoSuchFlowExecutionException(context.getFlowExecutionContext().getKey(), (Exception)new UnauthorizedServiceException("screen.service.required.message", "Service is required"));
        }
        WebUtils.putServiceIntoFlowScope((RequestContext)context, (Service)service);
    }

    private void configureWebflowContext(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        WebUtils.putTicketGrantingTicketInScopes((RequestContext)context, (String)this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request));
        WebUtils.putWarningCookie((RequestContext)context, (Boolean)Boolean.valueOf(this.warnCookieGenerator.retrieveCookieValue(request)));
        WebUtils.putGoogleAnalyticsTrackingIdIntoFlowScope((RequestContext)context, (Object)this.casProperties.getGoogleAnalytics().getGoogleAnalyticsTrackingId());
        WebUtils.putGeoLocationTrackingIntoFlowScope((RequestContext)context, (Object)this.casProperties.getEvents().isTrackGeolocation());
        WebUtils.putPasswordManagementEnabled((RequestContext)context, (Boolean)this.casProperties.getAuthn().getPm().isEnabled());
        WebUtils.putRememberMeAuthenticationEnabled((RequestContext)context, (Boolean)this.casProperties.getTicket().getTgt().getRememberMe().isEnabled());
        WebUtils.putStaticAuthenticationIntoFlowScope((RequestContext)context, (Object)(StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getAccept().getUsers()) || StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getReject().getUsers()) ? 1 : 0));
        if (this.casProperties.getAuthn().getPolicy().isSourceSelectionEnabled()) {
            List availableHandlers = this.authenticationEventExecutionPlan.getAuthenticationHandlers().stream().filter(h -> h.supports(UsernamePasswordCredential.class)).map(h -> StringUtils.capitalize((String)h.getName().trim())).distinct().sorted().collect(Collectors.toList());
            WebUtils.putAvailableAuthenticationHandleNames((RequestContext)context, availableHandlers);
        }
    }

    private void configureCookieGenerators(RequestContext context) {
        Object cookiePath;
        String contextPath = context.getExternalContext().getContextPath();
        Object object = cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + "/" : "/";
        if (StringUtils.isBlank((CharSequence)this.warnCookieGenerator.getCookiePath())) {
            LOGGER.info("Setting path for cookies for warn cookie generator to: [{}] ", cookiePath);
            this.warnCookieGenerator.setCookiePath((String)cookiePath);
        } else {
            LOGGER.trace("Warning cookie path is set to [{}] and path [{}]", (Object)this.warnCookieGenerator.getCookieDomain(), (Object)this.warnCookieGenerator.getCookiePath());
        }
        if (StringUtils.isBlank((CharSequence)this.ticketGrantingTicketCookieGenerator.getCookiePath())) {
            LOGGER.debug("Setting path for cookies for TGC cookie generator to: [{}] ", cookiePath);
            this.ticketGrantingTicketCookieGenerator.setCookiePath((String)cookiePath);
        } else {
            LOGGER.trace("TGC cookie path is set to [{}] and path [{}]", (Object)this.ticketGrantingTicketCookieGenerator.getCookieDomain(), (Object)this.ticketGrantingTicketCookieGenerator.getCookiePath());
        }
    }

    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public InitialFlowSetupAction(List<ArgumentExtractor> argumentExtractors, ServicesManager servicesManager, AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, CookieRetrievingCookieGenerator warnCookieGenerator, CasConfigurationProperties casProperties, AuthenticationEventExecutionPlan authenticationEventExecutionPlan) {
        this.argumentExtractors = argumentExtractors;
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.warnCookieGenerator = warnCookieGenerator;
        this.casProperties = casProperties;
        this.authenticationEventExecutionPlan = authenticationEventExecutionPlan;
    }
}

