/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.core.logout.LogoutProperties;
import org.apereo.cas.logout.LogoutRequestStatus;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.logout.AbstractLogoutAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class LogoutAction
extends AbstractLogoutAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutAction.class);
    private final ServiceFactory<WebApplicationService> webApplicationServiceFactory;
    private final ServicesManager servicesManager;
    private final LogoutProperties logoutProperties;

    @Override
    protected Event doInternalExecute(HttpServletRequest request, HttpServletResponse response, RequestContext context) {
        List logoutRequests = WebUtils.getLogoutRequests((RequestContext)context);
        Boolean needFrontSlo = (Boolean)FunctionUtils.doIf((logoutRequests != null ? 1 : 0) != 0, () -> logoutRequests.stream().anyMatch(logoutRequest -> logoutRequest.getStatus() == LogoutRequestStatus.NOT_ATTEMPTED), () -> Boolean.FALSE).get();
        String paramName = (String)StringUtils.defaultIfEmpty((CharSequence)this.logoutProperties.getRedirectParameter(), (CharSequence)"service");
        LOGGER.trace("Using parameter name [{}] to detect destination service, if any", (Object)paramName);
        String service = request.getParameter(paramName);
        LOGGER.trace("Located target service [{}] for redirection after logout", (Object)service);
        if (this.logoutProperties.isFollowServiceRedirects() && StringUtils.isNotBlank((CharSequence)service)) {
            WebApplicationService webAppService = (WebApplicationService)this.webApplicationServiceFactory.createService(service);
            RegisteredService rService = this.servicesManager.findServiceBy((Service)webAppService);
            if (rService != null && rService.getAccessStrategy().isServiceAccessAllowed()) {
                LOGGER.debug("Redirecting to service [{}]", (Object)service);
                WebUtils.putLogoutRedirectUrl((RequestContext)context, (String)service);
            } else {
                LOGGER.warn("Cannot redirect to [{}] given the service is unauthorized to use CAS. Ensure the service is registered with CAS and is enabled to allowed access", (Object)service);
            }
        } else {
            LOGGER.debug("No target service is located for redirection after logout, or CAS is not allowed to follow redirects after logout");
        }
        if (needFrontSlo.booleanValue()) {
            LOGGER.trace("Proceeding forward with front-channel single logout");
            return new Event((Object)this, "front");
        }
        LOGGER.trace("Moving forward to finish the logout process");
        return new Event((Object)this, "finish");
    }

    @Generated
    public LogoutAction(ServiceFactory<WebApplicationService> webApplicationServiceFactory, ServicesManager servicesManager, LogoutProperties logoutProperties) {
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.servicesManager = servicesManager;
        this.logoutProperties = logoutProperties;
    }
}

