/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.ext;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestDataHolder;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.BaseAccessTokenGrantRequestExtractor;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.OAuthToken;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenAuthorizationCodeGrantRequestExtractor
extends BaseAccessTokenGrantRequestExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessTokenAuthorizationCodeGrantRequestExtractor.class);

    public AccessTokenAuthorizationCodeGrantRequestExtractor(ServicesManager servicesManager, TicketRegistry ticketRegistry, CentralAuthenticationService centralAuthenticationService, OAuthProperties oAuthProperties) {
        super(servicesManager, ticketRegistry, centralAuthenticationService, oAuthProperties);
    }

    @Override
    public AccessTokenRequestDataHolder extract(HttpServletRequest request, HttpServletResponse response) {
        String grantType = request.getParameter("grant_type");
        Set<String> scopes = OAuth20Utils.parseRequestScopes(request);
        LOGGER.debug("OAuth grant type is [{}]", (Object)grantType);
        String clientId = request.getParameter("client_id");
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthService(this.servicesManager, clientId);
        if (registeredService == null) {
            throw new UnauthorizedServiceException("Unable to locate OAuth service in registry for client " + clientId);
        }
        LOGGER.debug("Located OAuth registered service [{}]", (Object)registeredService);
        OAuthToken token = this.getOAuthTokenFromRequest(request);
        if (token == null) {
            throw new InvalidTicketException(this.getOAuthParameter(request));
        }
        return new AccessTokenRequestDataHolder(token, registeredService, this.getGrantType(), this.isAllowedToGenerateRefreshToken(), scopes);
    }

    protected boolean isAllowedToGenerateRefreshToken() {
        return true;
    }

    protected String getOAuthParameterName() {
        return "code";
    }

    protected String getOAuthParameter(HttpServletRequest request) {
        return request.getParameter(this.getOAuthParameterName());
    }

    protected OAuthToken getOAuthTokenFromRequest(HttpServletRequest request) {
        OAuthToken token = (OAuthToken)this.ticketRegistry.getTicket(this.getOAuthParameter(request), OAuthToken.class);
        if (token == null || token.isExpired()) {
            LOGGER.error("OAuth token indicated by parameter [{}] has expired or not found: [{}]", (Object)this.getOAuthParameter(request), (Object)token);
            if (token != null) {
                this.ticketRegistry.deleteTicket(token.getId());
            }
            return null;
        }
        return token;
    }

    @Override
    public boolean supports(HttpServletRequest context) {
        String grantType = context.getParameter("grant_type");
        return OAuth20Utils.isGrantType(grantType, this.getGrantType());
    }

    @Override
    public OAuth20GrantTypes getGrantType() {
        return OAuth20GrantTypes.AUTHORIZATION_CODE;
    }
}

