/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.views;

import java.util.HashMap;
import java.util.Map;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.views.ConsentApprovalViewResolver;
import org.pac4j.core.context.J2EContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20ConsentApprovalViewResolver
implements ConsentApprovalViewResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20ConsentApprovalViewResolver.class);
    protected final CasConfigurationProperties casProperties;

    public OAuth20ConsentApprovalViewResolver(CasConfigurationProperties casProperties) {
        this.casProperties = casProperties;
    }

    @Override
    public ModelAndView resolve(J2EContext context, OAuthRegisteredService service) {
        Object bypassApprovalParameter = context.getSessionAttribute("bypass_approval_prompt");
        LOGGER.debug("Bypassing approval prompt for service [{}]: [{}]", (Object)service, bypassApprovalParameter);
        if (bypassApprovalParameter != null || this.isConsentApprovalBypassed(context, service)) {
            return new ModelAndView();
        }
        return this.redirectToApproveView(context, service);
    }

    protected boolean isConsentApprovalBypassed(J2EContext context, OAuthRegisteredService service) {
        return service.isBypassApprovalPrompt();
    }

    protected ModelAndView redirectToApproveView(J2EContext ctx, OAuthRegisteredService svc) {
        String callbackUrl = ctx.getFullRequestURL();
        ctx.setSessionAttribute("bypass_approval_prompt", (Object)Boolean.TRUE);
        LOGGER.debug("callbackUrl: [{}]", (Object)callbackUrl);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("service", svc);
        model.put("callbackUrl", callbackUrl);
        model.put("serviceName", svc.getName());
        model.put("deniedApprovalUrl", svc.getAccessStrategy().getUnauthorizedRedirectUrl());
        this.prepareApprovalViewModel(model, ctx, svc);
        return this.getApprovalModelAndView(model);
    }

    protected ModelAndView getApprovalModelAndView(Map<String, Object> model) {
        return new ModelAndView(this.getApprovalViewName(), model);
    }

    protected String getApprovalViewName() {
        return "oauthConfirmView";
    }

    protected void prepareApprovalViewModel(Map<String, Object> model, J2EContext ctx, OAuthRegisteredService svc) {
    }
}

