/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.rest;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CipherExecutor;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.support.pm.PasswordManagementProperties;
import org.apereo.cas.pm.BasePasswordManagementService;
import org.apereo.cas.pm.PasswordChangeBean;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class RestPasswordManagementService
extends BasePasswordManagementService {
    private final RestTemplate restTemplate;

    public RestPasswordManagementService(CipherExecutor<Serializable, String> cipherExecutor, String issuer, RestTemplate restTemplate, PasswordManagementProperties passwordManagementProperties) {
        super(cipherExecutor, issuer, passwordManagementProperties);
        this.restTemplate = restTemplate;
    }

    @Override
    public boolean change(Credential c, PasswordChangeBean bean) {
        PasswordManagementProperties.Rest rest = this.passwordManagementProperties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlChange())) {
            return false;
        }
        UsernamePasswordCredential upc = (UsernamePasswordCredential)c;
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.put("username", Arrays.asList(upc.getUsername()));
        headers.put("password", Arrays.asList(bean.getPassword()));
        headers.put("oldPassword", Arrays.asList(upc.getPassword()));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlChange(), HttpMethod.POST, entity, Boolean.class, new Object[0]);
        if (result.getStatusCodeValue() == HttpStatus.OK.value()) {
            return (Boolean)result.getBody();
        }
        return false;
    }

    @Override
    public String findEmail(String username) {
        PasswordManagementProperties.Rest rest = this.passwordManagementProperties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlEmail())) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.put("username", Arrays.asList(username));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlEmail(), HttpMethod.GET, entity, String.class, new Object[0]);
        if (result.getStatusCodeValue() == HttpStatus.OK.value() && result.hasBody()) {
            return (String)result.getBody();
        }
        return null;
    }

    @Override
    public Map<String, String> getSecurityQuestions(String username) {
        PasswordManagementProperties.Rest rest = this.passwordManagementProperties.getRest();
        if (StringUtils.isBlank((CharSequence)rest.getEndpointUrlSecurityQuestions())) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.put("username", Arrays.asList(username));
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.exchange(rest.getEndpointUrlSecurityQuestions(), HttpMethod.GET, entity, Map.class, new Object[0]);
        if (result.getStatusCodeValue() == HttpStatus.OK.value() && result.hasBody()) {
            return (Map)result.getBody();
        }
        return null;
    }
}

